/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater.download;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.updater.download.DownloadJob$1;
import net.minecraft.launcher.updater.download.DownloadListener;
import net.minecraft.launcher.updater.download.Downloadable;
import net.minecraft.launcher.updater.download.ProgressContainer;

public class DownloadJob {
    private static final int MAX_ATTEMPTS_PER_FILE = 5;
    private static final int ASSUMED_AVERAGE_FILE_SIZE = 0x500000;
    private final Queue<Downloadable> remainingFiles = new ConcurrentLinkedQueue<Downloadable>();
    private final List<Downloadable> allFiles = Collections.synchronizedList(new ArrayList());
    private final List<Downloadable> failures = Collections.synchronizedList(new ArrayList());
    private final List<Downloadable> successful = Collections.synchronizedList(new ArrayList());
    private final List<ProgressContainer> progressContainers = Collections.synchronizedList(new ArrayList());
    private final DownloadListener listener;
    private final String name;
    private final boolean ignoreFailures;
    private final AtomicInteger remainingThreads = new AtomicInteger();
    private boolean started;

    public DownloadJob(String string, boolean bl, DownloadListener downloadListener, Collection<Downloadable> collection) {
        this.name = string;
        this.ignoreFailures = bl;
        this.listener = downloadListener;
        if (collection != null) {
            this.addDownloadables(collection);
        }
    }

    public DownloadJob(String string, boolean bl, DownloadListener downloadListener) {
        this(string, bl, downloadListener, null);
    }

    public void addDownloadables(Collection<Downloadable> object) {
        if (this.started) {
            throw new IllegalStateException("Cannot add to download job that has already started");
        }
        this.allFiles.addAll((Collection<Downloadable>)object);
        this.remainingFiles.addAll((Collection<Downloadable>)object);
        object = object.iterator();
        while (object.hasNext()) {
            Downloadable downloadable = (Downloadable)object.next();
            this.progressContainers.add(downloadable.getMonitor());
            if (downloadable.getExpectedSize() == 0L) {
                downloadable.getMonitor().setTotal(0x500000L);
            } else {
                downloadable.getMonitor().setTotal(downloadable.getExpectedSize());
            }
            downloadable.getMonitor().setJob(this);
        }
    }

    public void addDownloadables(Downloadable ... downloadableArray) {
        if (this.started) {
            throw new IllegalStateException("Cannot add to download job that has already started");
        }
        for (Downloadable downloadable : downloadableArray) {
            this.allFiles.add(downloadable);
            this.remainingFiles.add(downloadable);
            this.progressContainers.add(downloadable.getMonitor());
            if (downloadable.getExpectedSize() == 0L) {
                downloadable.getMonitor().setTotal(0x500000L);
            } else {
                downloadable.getMonitor().setTotal(downloadable.getExpectedSize());
            }
            downloadable.getMonitor().setJob(this);
        }
    }

    public void startDownloading(ThreadPoolExecutor threadPoolExecutor) {
        if (this.started) {
            throw new IllegalStateException("Cannot start download job that has already started");
        }
        this.started = true;
        if (this.allFiles.isEmpty()) {
            Launcher.getInstance().println("Download job '" + this.name + "' skipped as there are no files to download");
            this.listener.onDownloadJobFinished(this);
            return;
        }
        int n2 = threadPoolExecutor.getMaximumPoolSize();
        this.remainingThreads.set(n2);
        Launcher.getInstance().println("Download job '" + this.name + "' started (" + n2 + " threads, " + this.allFiles.size() + " files)");
        for (int i2 = 0; i2 < n2; ++i2) {
            threadPoolExecutor.submit(new DownloadJob$1(this));
        }
    }

    private void popAndDownload() {
        Downloadable downloadable;
        while ((downloadable = this.remainingFiles.poll()) != null) {
            if (downloadable.getNumAttempts() > 5) {
                if (!this.ignoreFailures) {
                    this.failures.add(downloadable);
                }
                Launcher.getInstance().println("Gave up trying to download " + downloadable.getUrl() + " for job '" + this.name + "'");
                continue;
            }
            try {
                String string = downloadable.download();
                this.successful.add(downloadable);
                Launcher.getInstance().println("Finished downloading " + downloadable.getTarget() + " for job '" + this.name + "'" + ": " + string);
            }
            catch (Throwable throwable) {
                Launcher.getInstance().println("Couldn't download " + downloadable.getUrl() + " for job '" + this.name + "'", throwable);
                this.remainingFiles.add(downloadable);
            }
        }
        if (this.remainingThreads.decrementAndGet() <= 0) {
            this.listener.onDownloadJobFinished(this);
        }
    }

    public boolean shouldIgnoreFailures() {
        return this.ignoreFailures;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isComplete() {
        return this.started && this.remainingFiles.isEmpty() && this.remainingThreads.get() == 0;
    }

    public int getFailures() {
        return this.failures.size();
    }

    public int getSuccessful() {
        return this.successful.size();
    }

    public String getName() {
        return this.name;
    }

    public void updateProgress() {
        this.listener.onDownloadJobProgressChanged(this);
    }

    public float getProgress() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        List<ProgressContainer> list = this.progressContainers;
        synchronized (list) {
            for (ProgressContainer progressContainer : this.progressContainers) {
                f3 += (float)progressContainer.getTotal();
                f2 += (float)progressContainer.getCurrent();
            }
        }
        float f4 = -1.0f;
        if (f3 > 0.0f) {
            f4 = f2 / f3;
        }
        return f4;
    }

    static /* synthetic */ void a(DownloadJob downloadJob) {
        downloadJob.popAndDownload();
    }
}

