/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import net.minecraft.launcher.updater.VersionSyncInfo$VersionSource;
import net.minecraft.launcher.versions.Version;

public class VersionSyncInfo {
    private final Version localVersion;
    private final Version remoteVersion;
    private final boolean isInstalled;
    private final boolean isUpToDate;

    public VersionSyncInfo(Version version, Version version2, boolean bl, boolean bl2) {
        this.localVersion = version;
        this.remoteVersion = version2;
        this.isInstalled = bl;
        this.isUpToDate = bl2;
    }

    public Version getLocalVersion() {
        return this.localVersion;
    }

    public Version getRemoteVersion() {
        return this.remoteVersion;
    }

    public Version getLatestVersion() {
        if (this.getLatestSource() == VersionSyncInfo$VersionSource.REMOTE) {
            return this.remoteVersion;
        }
        return this.localVersion;
    }

    public VersionSyncInfo$VersionSource getLatestSource() {
        if (this.getLocalVersion() == null) {
            return VersionSyncInfo$VersionSource.REMOTE;
        }
        if (this.getRemoteVersion() == null) {
            return VersionSyncInfo$VersionSource.LOCAL;
        }
        if (this.getRemoteVersion().getUpdatedTime().after(this.getLocalVersion().getUpdatedTime())) {
            return VersionSyncInfo$VersionSource.REMOTE;
        }
        return VersionSyncInfo$VersionSource.LOCAL;
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public boolean isOnRemote() {
        return this.remoteVersion != null;
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    public final String toString() {
        return "VersionSyncInfo{localVersion=" + this.localVersion + ", remoteVersion=" + this.remoteVersion + ", isInstalled=" + this.isInstalled + ", isUpToDate=" + this.isUpToDate + '}';
    }
}

