/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.events.RefreshedVersionsListener;
import net.minecraft.launcher.updater.ExceptionalThreadPoolExecutor;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.updater.VersionManager$1;
import net.minecraft.launcher.updater.VersionManager$2;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.updater.VersionSyncInfo$VersionSource;
import net.minecraft.launcher.updater.download.DownloadJob;
import net.minecraft.launcher.updater.download.Downloadable;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VersionManager {
    private final VersionList localVersionList;
    private final VersionList remoteVersionList;
    private final ThreadPoolExecutor executorService = new ExceptionalThreadPoolExecutor(8);
    private final List<RefreshedVersionsListener> refreshedVersionsListeners = Collections.synchronizedList(new ArrayList());
    private final Object refreshLock = new Object();
    private boolean isRefreshing;

    public VersionManager(VersionList versionList, VersionList versionList2) {
        this.localVersionList = versionList;
        this.remoteVersionList = versionList2;
    }

    public void refreshVersions() {
        Object object;
        Object object3 = this.refreshLock;
        synchronized (object3) {
            this.isRefreshing = true;
        }
        try {
            this.localVersionList.refreshVersions();
        }
        catch (IOException iOException) {
            Object object4 = this.refreshLock;
            synchronized (object4) {
                this.isRefreshing = false;
            }
            throw iOException;
        }
        if (this.localVersionList instanceof LocalVersionList) {
            for (Version object22 : this.remoteVersionList.getVersions()) {
                object = object22.getId();
                if (this.localVersionList.getVersion((String)object) == null) continue;
                this.localVersionList.removeVersion((String)object);
                this.localVersionList.addVersion(this.remoteVersionList.getCompleteVersion((String)object));
                try {
                    ((LocalVersionList)this.localVersionList).saveVersion(this.localVersionList.getCompleteVersion((String)object));
                }
                catch (IOException iOException) {
                    Object object2 = this.refreshLock;
                    synchronized (object2) {
                        this.isRefreshing = false;
                    }
                    throw iOException;
                }
            }
        }
        object3 = this.refreshLock;
        synchronized (object3) {
            this.isRefreshing = false;
        }
        object3 = new ArrayList<RefreshedVersionsListener>(this.refreshedVersionsListeners);
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object = (RefreshedVersionsListener)iterator.next();
            if (object.shouldReceiveEventsInUIThread()) continue;
            object.onVersionsRefreshed(this);
            iterator.remove();
        }
        if (!object3.isEmpty()) {
            SwingUtilities.invokeLater(new VersionManager$1(this, (List)object3));
        }
    }

    public List<VersionSyncInfo> getVersions() {
        return this.getVersions(null);
    }

    public List<VersionSyncInfo> getVersions(VersionFilter versionFilter) {
        ArrayList<VersionSyncInfo> arrayList = this.refreshLock;
        synchronized (arrayList) {
            if (this.isRefreshing) {
                return new ArrayList<VersionSyncInfo>();
            }
        }
        arrayList = new ArrayList<VersionSyncInfo>();
        HashMap<String, VersionSyncInfo> hashMap = new HashMap<String, VersionSyncInfo>();
        EnumMap<ReleaseType, Integer> enumMap = new EnumMap<ReleaseType, Integer>(ReleaseType.class);
        for (ReleaseType releaseType : ReleaseType.values()) {
            enumMap.put(releaseType, 0);
        }
        for (Version version : this.localVersionList.getVersions()) {
            if (version.getType() == null || version.getUpdatedTime() == null || versionFilter != null && (!versionFilter.getTypes().contains((Object)version.getType()) || (Integer)enumMap.get((Object)version.getType()) >= versionFilter.getMaxCount())) continue;
            VersionSyncInfo versionSyncInfo = this.getVersionSyncInfo(version, this.remoteVersionList.getVersion(version.getId()));
            hashMap.put(version.getId(), versionSyncInfo);
            arrayList.add(versionSyncInfo);
        }
        for (Version version : this.remoteVersionList.getVersions()) {
            if (version.getType() == null || version.getUpdatedTime() == null || hashMap.containsKey(version.getId()) || versionFilter != null && (!versionFilter.getTypes().contains((Object)version.getType()) || (Integer)enumMap.get((Object)version.getType()) >= versionFilter.getMaxCount())) continue;
            VersionSyncInfo versionSyncInfo = this.getVersionSyncInfo(this.localVersionList.getVersion(version.getId()), version);
            hashMap.put(version.getId(), versionSyncInfo);
            arrayList.add(versionSyncInfo);
            if (versionFilter == null) continue;
            enumMap.put(version.getType(), (Integer)enumMap.get((Object)version.getType()) + 1);
        }
        if (arrayList.isEmpty()) {
            for (Version version : this.localVersionList.getVersions()) {
                if (version.getType() == null || version.getUpdatedTime() == null) continue;
                VersionSyncInfo versionSyncInfo = this.getVersionSyncInfo(version, this.remoteVersionList.getVersion(version.getId()));
                hashMap.put(version.getId(), versionSyncInfo);
                arrayList.add(versionSyncInfo);
                break;
            }
        }
        Collections.sort(arrayList, new VersionManager$2(this));
        return arrayList;
    }

    public VersionSyncInfo getVersionSyncInfo(Version version) {
        return this.getVersionSyncInfo(version.getId());
    }

    public VersionSyncInfo getVersionSyncInfo(String string) {
        return this.getVersionSyncInfo(this.localVersionList.getVersion(string), this.remoteVersionList.getVersion(string));
    }

    public VersionSyncInfo getVersionSyncInfo(Version version, Version version2) {
        boolean bl = version != null;
        boolean bl2 = bl;
        if (bl && version2 != null) {
            boolean bl3 = bl2 = !version2.getUpdatedTime().after(version.getUpdatedTime());
        }
        if (version instanceof CompleteVersion) {
            bl2 &= this.localVersionList.hasAllFiles((CompleteVersion)version, OperatingSystem.getCurrentPlatform());
        }
        return new VersionSyncInfo(version, version2, bl, bl2);
    }

    public List<VersionSyncInfo> getInstalledVersions() {
        ArrayList<VersionSyncInfo> arrayList = new ArrayList<VersionSyncInfo>();
        for (Version version : this.localVersionList.getVersions()) {
            if (version.getType() == null || version.getUpdatedTime() == null) continue;
            VersionSyncInfo versionSyncInfo = this.getVersionSyncInfo(version, this.remoteVersionList.getVersion(version.getId()));
            arrayList.add(versionSyncInfo);
        }
        return arrayList;
    }

    public VersionList getRemoteVersionList() {
        return this.remoteVersionList;
    }

    public VersionList getLocalVersionList() {
        return this.localVersionList;
    }

    public CompleteVersion getLatestCompleteVersion(VersionSyncInfo versionSyncInfo) {
        if (versionSyncInfo.getLatestSource() == VersionSyncInfo$VersionSource.REMOTE) {
            CompleteVersion completeVersion = null;
            IOException iOException = null;
            try {
                completeVersion = this.remoteVersionList.getCompleteVersion(versionSyncInfo.getLatestVersion());
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                iOException = iOException2;
                try {
                    completeVersion = this.localVersionList.getCompleteVersion(versionSyncInfo.getLatestVersion());
                }
                catch (IOException iOException3) {}
            }
            if (completeVersion != null) {
                return completeVersion;
            }
            throw iOException;
        }
        return this.localVersionList.getCompleteVersion(versionSyncInfo.getLatestVersion());
    }

    public DownloadJob downloadVersion(VersionSyncInfo object, DownloadJob downloadJob) {
        if (!(this.localVersionList instanceof LocalVersionList)) {
            throw new IllegalArgumentException("Cannot download if local repo isn't a LocalVersionList");
        }
        if (!(this.remoteVersionList instanceof RemoteVersionList)) {
            throw new IllegalArgumentException("Cannot download if local repo isn't a RemoteVersionList");
        }
        object = this.getLatestCompleteVersion((VersionSyncInfo)object);
        File file = ((LocalVersionList)this.localVersionList).getBaseDirectory();
        Proxy proxy = ((RemoteVersionList)this.remoteVersionList).getProxy();
        downloadJob.addDownloadables(((CompleteVersion)object).getRequiredDownloadables(OperatingSystem.getCurrentPlatform(), proxy, file, false));
        object = "versions/" + ((CompleteVersion)object).getId() + "/" + ((CompleteVersion)object).getId() + ".jar";
        downloadJob.addDownloadables(new Downloadable(proxy, new URL("https://s3.amazonaws.com/Minecraft.Download/" + (String)object), new File(file, (String)object), false));
        return downloadJob;
    }

    public DownloadJob downloadResources(DownloadJob downloadJob) {
        File file = ((LocalVersionList)this.localVersionList).getBaseDirectory();
        downloadJob.addDownloadables(this.getResourceFiles(((RemoteVersionList)this.remoteVersionList).getProxy(), file));
        return downloadJob;
    }

    private Set<Downloadable> getResourceFiles(Proxy proxy, File file) {
        HashSet<Downloadable> hashSet = new HashSet<Downloadable>();
        try {
            Object object = new URL("https://s3.amazonaws.com/Minecraft.Resources/");
            Object object2 = DocumentBuilderFactory.newInstance();
            object2 = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            object = ((DocumentBuilder)object2).parse(((URL)object).openConnection(proxy).getInputStream());
            object = object.getElementsByTagName("Contents");
            long l2 = System.nanoTime();
            for (int i2 = 0; i2 < object.getLength(); ++i2) {
                Object object3;
                Node node = object.item(i2);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String string = element.getElementsByTagName("Key").item(0).getChildNodes().item(0).getNodeValue();
                object2 = element.getElementsByTagName("ETag") != null ? element.getElementsByTagName("ETag").item(0).getChildNodes().item(0).getNodeValue() : "-";
                long l3 = Long.parseLong(element.getElementsByTagName("Size").item(0).getChildNodes().item(0).getNodeValue());
                if (l3 <= 0L) continue;
                File file2 = new File(file, "assets/" + string);
                if (((String)object2).length() > 1) {
                    object2 = Downloadable.getEtag((String)object2);
                    if (file2.isFile() && file2.length() == l3 && ((String)(object3 = Downloadable.getMD5(file2))).equals(object2)) continue;
                }
                object3 = new Downloadable(proxy, new URL("https://s3.amazonaws.com/Minecraft.Resources/" + string), file2, false);
                ((Downloadable)object3).setExpectedSize(l3);
                hashSet.add((Downloadable)object3);
            }
            long l4 = System.nanoTime();
            long l5 = l4 - l2;
            Launcher.getInstance().println("Delta time to compare resources: " + l5 / 1000000L + " ms ");
        }
        catch (Exception exception) {
            Launcher.getInstance().println("Couldn't download resources", exception);
        }
        return hashSet;
    }

    public ThreadPoolExecutor getExecutorService() {
        return this.executorService;
    }

    public void addRefreshedVersionsListener(RefreshedVersionsListener refreshedVersionsListener) {
        this.refreshedVersionsListeners.add(refreshedVersionsListener);
    }

    public void removeRefreshedVersionsListener(RefreshedVersionsListener refreshedVersionsListener) {
        this.refreshedVersionsListeners.remove(refreshedVersionsListener);
    }
}

