/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.updater.DateTypeAdapter;
import net.minecraft.launcher.updater.LowerCaseEnumTypeAdapterFactory;
import net.minecraft.launcher.updater.VersionList$RawVersionList;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.PartialVersion;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;

public abstract class VersionList {
    protected final Gson gson;
    private final Map<String, Version> versionsByName = new HashMap<String, Version>();
    private final List<Version> versions = new ArrayList<Version>();
    private final Map<ReleaseType, Version> latestVersions = new EnumMap<ReleaseType, Version>(ReleaseType.class);

    public VersionList() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        gsonBuilder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        gsonBuilder.enableComplexMapKeySerialization();
        gsonBuilder.setPrettyPrinting();
        this.gson = gsonBuilder.create();
    }

    public Collection<Version> getVersions() {
        return this.versions;
    }

    public Version getLatestVersion(ReleaseType releaseType) {
        if (releaseType == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        return this.latestVersions.get((Object)releaseType);
    }

    public Version getVersion(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return this.versionsByName.get(string);
    }

    public CompleteVersion getCompleteVersion(String object) {
        if (object == null || ((String)object).length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if ((object = this.getVersion((String)object)) == null) {
            throw new IllegalArgumentException("Unknown version - cannot get complete version of null");
        }
        return this.getCompleteVersion((Version)object);
    }

    public CompleteVersion getCompleteVersion(Version version) {
        if (version instanceof CompleteVersion) {
            return (CompleteVersion)version;
        }
        if (version == null) {
            throw new IllegalArgumentException("Version cannot be null");
        }
        CompleteVersion completeVersion = this.gson.fromJson(this.getContent("versions/" + version.getId() + "/" + version.getId() + ".json"), CompleteVersion.class);
        ReleaseType releaseType = version.getType();
        Collections.replaceAll(this.versions, version, completeVersion);
        this.versionsByName.put(version.getId(), completeVersion);
        if (this.latestVersions.get((Object)releaseType) == version) {
            this.latestVersions.put(releaseType, completeVersion);
        }
        return completeVersion;
    }

    protected void clearCache() {
        this.versionsByName.clear();
        this.versions.clear();
        this.latestVersions.clear();
    }

    public void refreshVersions() {
        this.clearCache();
        VersionList$RawVersionList versionList$RawVersionList = this.gson.fromJson(this.getContent("versions/versions.json"), VersionList$RawVersionList.class);
        for (PartialVersion partialVersion : versionList$RawVersionList.getVersions()) {
            this.versions.add(partialVersion);
            this.versionsByName.put(partialVersion.getId(), partialVersion);
        }
        for (ReleaseType releaseType : ReleaseType.values()) {
            this.latestVersions.put(releaseType, this.versionsByName.get(versionList$RawVersionList.getLatestVersions().get((Object)releaseType)));
        }
    }

    public CompleteVersion addVersion(CompleteVersion completeVersion) {
        if (completeVersion.getId() == null) {
            throw new IllegalArgumentException("Cannot add blank version");
        }
        if (this.getVersion(completeVersion.getId()) != null) {
            throw new IllegalArgumentException("Version '" + completeVersion.getId() + "' is already tracked");
        }
        this.versions.add(completeVersion);
        this.versionsByName.put(completeVersion.getId(), completeVersion);
        return completeVersion;
    }

    public void removeVersion(String object) {
        if (object == null || ((String)object).length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if ((object = this.getVersion((String)object)) == null) {
            throw new IllegalArgumentException("Unknown version - cannot remove null");
        }
        this.removeVersion((Version)object);
    }

    public void removeVersion(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Cannot remove null version");
        }
        this.versions.remove(version);
        this.versionsByName.remove(version.getId());
        for (ReleaseType releaseType : ReleaseType.values()) {
            if (this.getLatestVersion(releaseType) != version) continue;
            this.latestVersions.remove((Object)releaseType);
        }
    }

    public void setLatestVersion(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Cannot set latest version to null");
        }
        this.latestVersions.put(version.getType(), version);
    }

    public void setLatestVersion(String object) {
        if (object == null || ((String)object).length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if ((object = this.getVersion((String)object)) == null) {
            throw new IllegalArgumentException("Unknown version - cannot set latest version to null");
        }
        this.setLatestVersion((Version)object);
    }

    public String serializeVersionList() {
        VersionList$RawVersionList versionList$RawVersionList = new VersionList$RawVersionList();
        for (ReleaseType releaseType : ReleaseType.values()) {
            Version version = this.getLatestVersion(releaseType);
            if (version == null) continue;
            versionList$RawVersionList.getLatestVersions().put(releaseType, version.getId());
        }
        for (Version version : this.getVersions()) {
            PartialVersion partialVersion = version instanceof PartialVersion ? (PartialVersion)version : new PartialVersion(version);
            versionList$RawVersionList.getVersions().add(partialVersion);
        }
        return this.gson.toJson(versionList$RawVersionList);
    }

    public String serializeVersion(CompleteVersion completeVersion) {
        if (completeVersion == null) {
            throw new IllegalArgumentException("Cannot serialize null!");
        }
        return this.gson.toJson(completeVersion);
    }

    public abstract boolean hasAllFiles(CompleteVersion var1, OperatingSystem var2);

    protected abstract String getContent(String var1);
}

