/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.launcher.versions.ReleaseType;

public class VersionFilter {
    private final Set<ReleaseType> types = new HashSet<ReleaseType>();
    private int maxCount = 5;

    public VersionFilter() {
        Collections.addAll(this.types, ReleaseType.values());
    }

    public Set<ReleaseType> getTypes() {
        return this.types;
    }

    public VersionFilter onlyForTypes(ReleaseType ... releaseTypeArray) {
        this.types.clear();
        this.includeTypes(releaseTypeArray);
        return this;
    }

    public VersionFilter includeTypes(ReleaseType ... releaseTypeArray) {
        if (releaseTypeArray != null) {
            Collections.addAll(this.types, releaseTypeArray);
        }
        return this;
    }

    public VersionFilter excludeTypes(ReleaseType ... releaseTypeArray) {
        if (releaseTypeArray != null) {
            for (ReleaseType releaseType : releaseTypeArray) {
                this.types.remove((Object)releaseType);
            }
        }
        return this;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public VersionFilter setMaxCount(int n2) {
        this.maxCount = n2;
        return this;
    }
}

