/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.updater.FileBasedVersionList;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;

public class LocalVersionList
extends FileBasedVersionList {
    private final File baseDirectory;
    private final File baseVersionsDir;

    public LocalVersionList(File file) {
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException("Base directory is not a folder!");
        }
        this.baseDirectory = file;
        this.baseVersionsDir = new File(this.baseDirectory, "versions");
        if (!this.baseVersionsDir.isDirectory()) {
            this.baseVersionsDir.mkdirs();
        }
    }

    @Override
    protected InputStream getFileInputStream(String string) {
        return new FileInputStream(new File(this.baseDirectory, string));
    }

    @Override
    public void refreshVersions() {
        this.clearCache();
        File[] fileArray = this.baseVersionsDir.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File runtimeException : fileArray) {
            String string = runtimeException.getName();
            File file = new File(runtimeException, string + ".json");
            if (!runtimeException.isDirectory() || !file.exists()) continue;
            try {
                String string2 = "versions/" + string + "/" + string + ".json";
                CompleteVersion completeVersion = this.gson.fromJson(this.getContent(string2), CompleteVersion.class);
                if (completeVersion.getId().equals(string)) {
                    this.addVersion(completeVersion);
                    continue;
                }
                if (Launcher.getInstance() == null) continue;
                Launcher.getInstance().println("Ignoring: " + string2 + "; it contains id: '" + completeVersion.getId() + "' expected '" + string + "'");
            }
            catch (RuntimeException runtimeException2) {
                if (Launcher.getInstance() != null) {
                    Launcher.getInstance().println("Couldn't load local version " + file.getAbsolutePath(), runtimeException2);
                    continue;
                }
                throw new JsonSyntaxException("Loading file: " + file.toString(), runtimeException2);
            }
        }
        for (Version version : this.getVersions()) {
            ReleaseType releaseType = version.getType();
            if (this.getLatestVersion(releaseType) != null && !this.getLatestVersion(releaseType).getUpdatedTime().before(version.getUpdatedTime())) continue;
            this.setLatestVersion(version);
        }
    }

    public void saveVersionList() {
        String string = this.serializeVersionList();
        PrintWriter printWriter = new PrintWriter(new File(this.baseVersionsDir, "versions.json"));
        printWriter.print(string);
        printWriter.close();
    }

    public void saveVersion(CompleteVersion object) {
        String string = this.serializeVersion((CompleteVersion)object);
        if (((File)(object = new File(this.baseVersionsDir, ((CompleteVersion)object).getId() + "/" + ((CompleteVersion)object).getId() + ".json"))).getParentFile() != null) {
            ((File)object).getParentFile().mkdirs();
        }
        object = new PrintWriter((File)object);
        ((PrintWriter)object).print(string);
        ((PrintWriter)object).close();
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    @Override
    public boolean hasAllFiles(CompleteVersion iterator, OperatingSystem object) {
        iterator = ((CompleteVersion)((Object)iterator)).getRequiredFiles((OperatingSystem)((Object)object));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (new File(this.baseDirectory, (String)object).isFile()) continue;
            return false;
        }
        return true;
    }
}

