/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateTypeAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private final DateFormat enUsFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private final DateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    @Override
    public Date deserialize(JsonElement object, Type type, JsonDeserializationContext jsonDeserializationContext) {
        if (!(object instanceof JsonPrimitive)) {
            throw new JsonParseException("The date should be a string value");
        }
        object = this.deserializeToDate((JsonElement)object);
        if (type == Date.class) {
            return object;
        }
        throw new IllegalArgumentException(this.getClass() + " cannot deserialize to " + type);
    }

    @Override
    public JsonElement serialize(Date date, Type object, JsonSerializationContext jsonSerializationContext) {
        object = this.enUsFormat;
        synchronized (object) {
            return new JsonPrimitive(this.serializeToString(date));
        }
    }

    private Date deserializeToDate(JsonElement jsonElement) {
        DateFormat dateFormat = this.enUsFormat;
        synchronized (dateFormat) {
            try {
                return this.enUsFormat.parse(jsonElement.getAsString());
            }
            catch (ParseException parseException) {
                try {
                    return this.iso8601Format.parse(jsonElement.getAsString());
                }
                catch (ParseException parseException2) {
                    try {
                        String string = jsonElement.getAsString().replace("Z", "+00:00");
                        string = string.substring(0, 22) + string.substring(23);
                        return this.iso8601Format.parse(string);
                    }
                    catch (Exception exception) {
                        throw new JsonSyntaxException("Invalid date: " + jsonElement.getAsString(), exception);
                    }
                }
            }
        }
    }

    private String serializeToString(Date object) {
        DateFormat dateFormat = this.enUsFormat;
        synchronized (dateFormat) {
            object = this.iso8601Format.format((Date)object);
            return ((String)object).substring(0, 22) + ":" + ((String)object).substring(22);
        }
    }
}

