/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.tabs;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.events.RefreshedVersionsListener;
import net.minecraft.launcher.ui.tabs.VersionListTab$VersionTableModel;
import net.minecraft.launcher.updater.VersionManager;

public class VersionListTab
extends JScrollPane
implements RefreshedVersionsListener {
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_TYPE = 1;
    private static final int COLUMN_RELEASE_DATE = 2;
    private static final int COLUMN_UPDATE_DATE = 3;
    private static final int COLUMN_LIBRARIES = 4;
    private static final int COLUMN_STATUS = 5;
    private static final int NUM_COLUMNS = 6;
    private final Launcher launcher;
    private final VersionListTab$VersionTableModel dataModel = new VersionListTab$VersionTableModel(this);
    private final JTable table = new JTable(this.dataModel);

    public VersionListTab(Launcher launcher) {
        this.launcher = launcher;
        this.setViewportView(this.table);
        this.createInterface();
        launcher.getVersionManager().addRefreshedVersionsListener(this);
    }

    protected void createInterface() {
        this.table.setFillsViewportHeight(true);
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    @Override
    public void onVersionsRefreshed(VersionManager versionManager) {
        this.dataModel.setVersions(versionManager.getLocalVersionList().getVersions());
    }

    @Override
    public boolean shouldReceiveEventsInUIThread() {
        return true;
    }

    static /* synthetic */ Launcher a(VersionListTab versionListTab) {
        return versionListTab.launcher;
    }
}

