/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.tabs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.ui.tabs.VersionListTab;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Version;

class VersionListTab$VersionTableModel
extends AbstractTableModel {
    private final List<Version> versions = new ArrayList<Version>();
    private /* synthetic */ VersionListTab this$0;

    private VersionListTab$VersionTableModel(VersionListTab versionListTab, byte by) {
        this.this$0 = versionListTab;
    }

    @Override
    public int getRowCount() {
        return this.versions.size();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        if (n2 == 3 || n2 == 2) {
            return Date.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int n2) {
        switch (n2) {
            case 3: {
                return "Last modified";
            }
            case 1: {
                return "Version type";
            }
            case 4: {
                return "Library count";
            }
            case 0: {
                return "Version name";
            }
            case 5: {
                return "Sync status";
            }
            case 2: {
                return "Release Date";
            }
        }
        return super.getColumnName(n2);
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        Object object = this.versions.get(n2);
        switch (n3) {
            case 0: {
                return object.getId();
            }
            case 3: {
                return object.getUpdatedTime();
            }
            case 4: {
                if (object instanceof CompleteVersion) {
                    int n4;
                    n3 = ((CompleteVersion)(object = (CompleteVersion)object)).getLibraries().size();
                    if (n3 == (n4 = ((CompleteVersion)object).getRelevantLibraries().size())) {
                        return n3;
                    }
                    return String.format("%d (%d relevant to %s)", n3, n4, OperatingSystem.getCurrentPlatform().getName());
                }
                return "?";
            }
            case 5: {
                object = VersionListTab.a(this.this$0).getVersionManager().getVersionSyncInfo((Version)object);
                if (((VersionSyncInfo)object).isOnRemote()) {
                    if (((VersionSyncInfo)object).isUpToDate()) {
                        return "Up to date with remote";
                    }
                    return "Update avail from remote";
                }
                return "Local only";
            }
            case 1: {
                return object.getType().getName();
            }
            case 2: {
                return object.getReleaseTime();
            }
        }
        return null;
    }

    public void setVersions(Collection<Version> collection) {
        this.versions.clear();
        this.versions.addAll(collection);
        this.fireTableDataChanged();
    }

    /* synthetic */ VersionListTab$VersionTableModel(VersionListTab versionListTab) {
        this(versionListTab, 0);
    }
}

