/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.tabs;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.events.RefreshedProfilesListener;
import net.minecraft.launcher.profile.ProfileManager;
import net.minecraft.launcher.ui.tabs.ProfileListTab$1;
import net.minecraft.launcher.ui.tabs.ProfileListTab$2;
import net.minecraft.launcher.ui.tabs.ProfileListTab$3;
import net.minecraft.launcher.ui.tabs.ProfileListTab$4;
import net.minecraft.launcher.ui.tabs.ProfileListTab$5;
import net.minecraft.launcher.ui.tabs.ProfileListTab$ProfileTableModel;

public class ProfileListTab
extends JScrollPane
implements RefreshedProfilesListener {
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_VERSION = 1;
    private static final int COLUMN_AUTHENTICATION = 2;
    private static final int NUM_COLUMNS = 3;
    private final Launcher launcher;
    private final ProfileListTab$ProfileTableModel dataModel = new ProfileListTab$ProfileTableModel(this);
    private final JTable table = new JTable(this.dataModel);
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final JMenuItem addProfileButton = new JMenuItem("Add Profile");
    private final JMenuItem copyProfileButton = new JMenuItem("Copy Profile");
    private final JMenuItem deleteProfileButton = new JMenuItem("Delete Profile");

    public ProfileListTab(Launcher launcher) {
        this.launcher = launcher;
        this.setViewportView(this.table);
        this.createInterface();
        launcher.getProfileManager().addRefreshedProfilesListener(this);
    }

    protected void createInterface() {
        this.popupMenu.add(this.addProfileButton);
        this.popupMenu.add(this.copyProfileButton);
        this.popupMenu.add(this.deleteProfileButton);
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.popupMenu.addPopupMenuListener(new ProfileListTab$1(this));
        this.addProfileButton.addActionListener(new ProfileListTab$2(this));
        this.copyProfileButton.addActionListener(new ProfileListTab$3(this));
        this.deleteProfileButton.addActionListener(new ProfileListTab$4(this));
        this.table.addMouseListener(new ProfileListTab$5(this));
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    @Override
    public void onProfilesRefreshed(ProfileManager profileManager) {
        this.dataModel.setProfiles(profileManager.getProfiles().values());
    }

    @Override
    public boolean shouldReceiveEventsInUIThread() {
        return true;
    }

    static /* synthetic */ JTable a(ProfileListTab profileListTab) {
        return profileListTab.table;
    }

    static /* synthetic */ JMenuItem b(ProfileListTab profileListTab) {
        return profileListTab.copyProfileButton;
    }

    static /* synthetic */ JMenuItem c(ProfileListTab profileListTab) {
        return profileListTab.deleteProfileButton;
    }

    static /* synthetic */ Launcher d(ProfileListTab profileListTab) {
        return profileListTab.launcher;
    }

    static /* synthetic */ ProfileListTab$ProfileTableModel e(ProfileListTab profileListTab) {
        return profileListTab.dataModel;
    }

    static /* synthetic */ JPopupMenu f(ProfileListTab profileListTab) {
        return profileListTab.popupMenu;
    }
}

