/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.tabs;

import java.awt.Component;
import javax.swing.JTabbedPane;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.ui.tabs.ConsoleTab;
import net.minecraft.launcher.ui.tabs.CrashReportTab;
import net.minecraft.launcher.ui.tabs.ProfileListTab;
import net.minecraft.launcher.ui.tabs.VersionListTab;
import net.minecraft.launcher.ui.tabs.WebsiteTab;

public class LauncherTabPanel
extends JTabbedPane {
    private final Launcher launcher;
    private final WebsiteTab blog;
    private final ConsoleTab console;
    private CrashReportTab crashReportTab;

    public LauncherTabPanel(Launcher launcher) {
        super(1);
        this.launcher = launcher;
        this.blog = new WebsiteTab(launcher);
        this.console = new ConsoleTab(launcher);
        this.createInterface();
    }

    protected void createInterface() {
        this.addTab("Update Notes", this.blog);
        this.addTab("Development Console", this.console);
        this.addTab("Profile Editor", new ProfileListTab(this.launcher));
        this.addTab("Local Version Editor (NYI)", new VersionListTab(this.launcher));
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public WebsiteTab getBlog() {
        return this.blog;
    }

    public ConsoleTab getConsole() {
        return this.console;
    }

    public void showConsole() {
        this.setSelectedComponent(this.console);
    }

    public void setCrashReport(CrashReportTab crashReportTab) {
        if (this.crashReportTab != null) {
            this.removeTab(this.crashReportTab);
        }
        this.crashReportTab = crashReportTab;
        this.addTab("Crash Report", this.crashReportTab);
        this.setSelectedComponent(crashReportTab);
    }

    protected void removeTab(Component component) {
        for (int i2 = 0; i2 < this.getTabCount(); ++i2) {
            if (this.getTabComponentAt(i2) != component) continue;
            this.removeTabAt(i2);
            return;
        }
    }
}

