/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.minecraft.hopper.HopperService;
import net.minecraft.hopper.SubmitResponse;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.ui.tabs.CrashReportTab$1;
import net.minecraft.launcher.ui.tabs.CrashReportTab$CrashInfoPane;
import net.minecraft.launcher.versions.CompleteVersion;

public class CrashReportTab
extends JPanel {
    private final Launcher launcher;
    private final CompleteVersion version;
    private final File reportFile;
    private final String report;
    private final JEditorPane reportEditor = new JEditorPane();
    private final JScrollPane scrollPane = new JScrollPane(this.reportEditor);
    private final CrashReportTab$CrashInfoPane crashInfoPane;
    private final boolean isModded;
    private SubmitResponse hopperServiceResponse = null;

    public CrashReportTab(Launcher launcher, CompleteVersion completeVersion, File file, String string) {
        super(true);
        this.launcher = launcher;
        this.version = completeVersion;
        this.reportFile = file;
        this.report = string;
        this.crashInfoPane = new CrashReportTab$CrashInfoPane(this, launcher);
        this.isModded = string.contains("Is Modded: Probably not") || string.contains("Is Modded: Unknown") ? !string.contains("Suspicious classes: No suspicious classes found.") : true;
        this.setLayout(new BorderLayout());
        this.createInterface();
        if (launcher.getProfileManager().getSelectedProfile().getUseHopperCrashService()) {
            launcher.getVersionManager().getExecutorService().submit(new CrashReportTab$1(this, launcher, string, completeVersion));
        }
    }

    private void showPublishReportPrompt() {
        Object[] objectArray = new String[]{"Publish Crash Report", "Cancel"};
        JLabel jLabel = new JLabel();
        jLabel.setText("<html><p>Sorry, but it looks like the game crashed and we don't know why.</p><p>Would you mind publishing this report so that " + (this.isModded ? "the mod authors" : "Mojang") + " can fix it?</p></html>");
        int n2 = JOptionPane.showOptionDialog(this, jLabel, "Uhoh, something went wrong!", 0, 1, null, objectArray, objectArray[0]);
        if (n2 == 0) {
            try {
                HopperService.publishReport(this.launcher.getProxy(), this.hopperServiceResponse.getReport());
                return;
            }
            catch (IOException iOException) {
                this.launcher.println("Couldn't publish report " + this.hopperServiceResponse.getReport().getId(), iOException);
            }
        }
    }

    private void showKnownProblemPopup() {
        if (this.hopperServiceResponse.getProblem().getUrl() == null) {
            JOptionPane.showMessageDialog(this, this.hopperServiceResponse.getProblem().getDescription(), this.hopperServiceResponse.getProblem().getTitle(), 1);
            return;
        }
        Object[] objectArray = new String[]{"Fix The Problem", "Cancel"};
        int n2 = JOptionPane.showOptionDialog(this, this.hopperServiceResponse.getProblem().getDescription(), this.hopperServiceResponse.getProblem().getTitle(), 0, 1, null, objectArray, objectArray[0]);
        if (n2 == 0) {
            try {
                OperatingSystem.openLink(new URI(this.hopperServiceResponse.getProblem().getUrl()));
                return;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.launcher.println("Couldn't open help page ( " + this.hopperServiceResponse.getProblem().getUrl() + "  ) for crash", uRISyntaxException);
            }
        }
    }

    protected void createInterface() {
        this.add((Component)this.crashInfoPane, "North");
        this.add((Component)this.scrollPane, "Center");
        this.reportEditor.setText(this.report);
        this.crashInfoPane.createInterface();
    }

    static /* synthetic */ SubmitResponse a(CrashReportTab crashReportTab, SubmitResponse submitResponse) {
        crashReportTab.hopperServiceResponse = submitResponse;
        return crashReportTab.hopperServiceResponse;
    }

    static /* synthetic */ SubmitResponse a(CrashReportTab crashReportTab) {
        return crashReportTab.hopperServiceResponse;
    }

    static /* synthetic */ void b(CrashReportTab crashReportTab) {
        crashReportTab.showKnownProblemPopup();
    }

    static /* synthetic */ void c(CrashReportTab crashReportTab) {
        crashReportTab.showPublishReportPrompt();
    }

    static /* synthetic */ boolean d(CrashReportTab crashReportTab) {
        return crashReportTab.isModded;
    }

    static /* synthetic */ File e(CrashReportTab crashReportTab) {
        return crashReportTab.reportFile;
    }

    static /* synthetic */ CompleteVersion f(CrashReportTab crashReportTab) {
        return crashReportTab.version;
    }
}

