/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.tabs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.minecraft.launcher.Http;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.ui.tabs.CrashReportTab;

class CrashReportTab$CrashInfoPane
extends JPanel
implements ActionListener {
    public static final String INFO_NORMAL = "<html><div style='width: 100%'><p><b>Uhoh, it looks like the game has crashed! Sorry for the inconvenience :(</b></p><p>Using magic and love, we've managed to gather some details about the crash and we will investigate this as soon as we can.</p><p>You can see the full report below.</p></div></html>";
    public static final String INFO_MODDED = "<html><div style='width: 100%'><p><b>Uhoh, it looks like the game has crashed! Sorry for the inconvenience :(</b></p><p>We think your game may be modded, and as such we can't accept this crash report.</p><p>However, if you do indeed use mods, please send this to the mod authors to take a look at!</p></div></html>";
    private final JButton submitButton = new JButton("Report to Mojang");
    private final JButton openFileButton = new JButton("Open report file");
    private /* synthetic */ CrashReportTab this$0;

    protected CrashReportTab$CrashInfoPane(CrashReportTab crashReportTab, Launcher launcher) {
        this.this$0 = crashReportTab;
        this.submitButton.addActionListener(this);
        this.openFileButton.addActionListener(this);
    }

    protected void createInterface() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.submitButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.openFileButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        this.add((Component)new JLabel(CrashReportTab.d(this.this$0) ? INFO_MODDED : INFO_NORMAL), gridBagConstraints);
        if (CrashReportTab.d(this.this$0)) {
            this.submitButton.setEnabled(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent serializable) {
        if (((EventObject)serializable).getSource() == this.submitButton) {
            if (CrashReportTab.a(this.this$0) != null) {
                if (CrashReportTab.a(this.this$0).getProblem() != null) {
                    CrashReportTab.b(this.this$0);
                    return;
                }
                if (!CrashReportTab.a(this.this$0).getReport().canBePublished()) return;
                CrashReportTab.c(this.this$0);
                return;
            }
            try {
                serializable = new HashMap<String, Integer>();
                serializable.put("pid", 10400);
                serializable.put("issuetype", 1);
                serializable.put("description", "Put the summary of the bug you're having here\n\n*What I expected to happen was...:*\nDescribe what you thought should happen here\n\n*What actually happened was...:*\nDescribe what happened here\n\n*Steps to Reproduce:*\n1. Put a step by step guide on how to trigger the bug here\n2. ...\n3. ...");
                serializable.put("environment", this.buildEnvironmentInfo());
                OperatingSystem.openLink(URI.create("https://mojang.atlassian.net/secure/CreateIssueDetails!init.jspa?" + Http.buildQuery((Map<String, Object>)((Object)serializable))));
                return;
            }
            catch (Throwable throwable) {
                Launcher.getInstance().println("Couldn't open bugtracker", throwable);
                return;
            }
        }
        if (((EventObject)serializable).getSource() != this.openFileButton) return;
        OperatingSystem.openLink(CrashReportTab.e(this.this$0).toURI());
    }

    private String buildEnvironmentInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OS: ");
        stringBuilder.append(System.getProperty("os.name"));
        stringBuilder.append(" (ver ");
        stringBuilder.append(System.getProperty("os.version"));
        stringBuilder.append(", arch ");
        stringBuilder.append(System.getProperty("os.arch"));
        stringBuilder.append(")\nJava: ");
        stringBuilder.append(System.getProperty("java.version"));
        stringBuilder.append(" (by ");
        stringBuilder.append(System.getProperty("java.vendor"));
        stringBuilder.append(")\nLauncher: ");
        stringBuilder.append("1.2.1");
        stringBuilder.append(" (bootstrap ");
        stringBuilder.append(Launcher.getInstance().getBootstrapVersion());
        stringBuilder.append(")\nMinecraft: ");
        stringBuilder.append(CrashReportTab.f(this.this$0).getId());
        stringBuilder.append(" (updated ");
        stringBuilder.append(CrashReportTab.f(this.this$0).getUpdatedTime());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

