/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.tabs;

import java.awt.Font;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.ui.tabs.ConsoleTab$1;

public class ConsoleTab
extends JScrollPane {
    private static final Font MONOSPACED = new Font("Monospaced", 0, 12);
    private final JTextPane console = new JTextPane();
    private final Launcher launcher;

    public ConsoleTab(Launcher launcher) {
        this.launcher = launcher;
        this.console.setFont(MONOSPACED);
        this.console.setEditable(false);
        this.console.setMargin(null);
        this.setViewportView(this.console);
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public void print(String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ConsoleTab$1(this, string));
            return;
        }
        Document document = this.console.getDocument();
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        boolean bl = false;
        if (this.getViewport().getView() == this.console) {
            bl = (double)jScrollBar.getValue() + jScrollBar.getSize().getHeight() + (double)(MONOSPACED.getSize() << 2) > (double)jScrollBar.getMaximum();
        }
        try {
            document.insertString(document.getLength(), string, null);
        }
        catch (BadLocationException badLocationException) {}
        if (bl) {
            jScrollBar.setValue(Integer.MAX_VALUE);
        }
    }
}

