/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.profile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.minecraft.launcher.events.RefreshedVersionsListener;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.ui.popups.profile.ProfileEditorPopup;
import net.minecraft.launcher.ui.popups.profile.ProfileVersionPanel$1;
import net.minecraft.launcher.ui.popups.profile.ProfileVersionPanel$2;
import net.minecraft.launcher.ui.popups.profile.ProfileVersionPanel$ReleaseTypeCheckBox;
import net.minecraft.launcher.ui.popups.profile.ProfileVersionPanel$VersionListRenderer;
import net.minecraft.launcher.updater.VersionManager;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.ReleaseType;

public class ProfileVersionPanel
extends JPanel
implements RefreshedVersionsListener {
    private final ProfileEditorPopup editor;
    private final JComboBox versionList = new JComboBox();
    private final List<ProfileVersionPanel$ReleaseTypeCheckBox> customVersionTypes = new ArrayList<ProfileVersionPanel$ReleaseTypeCheckBox>();

    public ProfileVersionPanel(ProfileEditorPopup profileEditorPopup) {
        this.editor = profileEditorPopup;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("Version Selection"));
        this.createInterface();
        this.addEventHandlers();
        List<VersionSyncInfo> list = profileEditorPopup.getLauncher().getVersionManager().getVersions(profileEditorPopup.getProfile().getVersionFilter());
        if (list.isEmpty()) {
            profileEditorPopup.getLauncher().getVersionManager().addRefreshedVersionsListener(this);
            return;
        }
        this.populateVersions(list);
    }

    protected void createInterface() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        for (ReleaseType releaseType : ReleaseType.values()) {
            if (releaseType.getDescription() == null) continue;
            ProfileVersionPanel$ReleaseTypeCheckBox profileVersionPanel$ReleaseTypeCheckBox = new ProfileVersionPanel$ReleaseTypeCheckBox(releaseType);
            profileVersionPanel$ReleaseTypeCheckBox.setSelected(this.editor.getProfile().getVersionFilter().getTypes().contains((Object)releaseType));
            this.customVersionTypes.add(profileVersionPanel$ReleaseTypeCheckBox);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            this.add((Component)profileVersionPanel$ReleaseTypeCheckBox, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridy;
        }
        this.add((Component)new JLabel("Use version:"), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.versionList, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        this.versionList.setRenderer(new ProfileVersionPanel$VersionListRenderer());
    }

    protected void addEventHandlers() {
        this.versionList.addItemListener(new ProfileVersionPanel$1(this));
        for (ProfileVersionPanel$ReleaseTypeCheckBox profileVersionPanel$ReleaseTypeCheckBox : this.customVersionTypes) {
            profileVersionPanel$ReleaseTypeCheckBox.addItemListener(new ProfileVersionPanel$2(this, profileVersionPanel$ReleaseTypeCheckBox));
        }
    }

    private void updateCustomVersionFilter() {
        Profile profile = this.editor.getProfile();
        HashSet<ReleaseType> hashSet = new HashSet<ReleaseType>(Profile.DEFAULT_RELEASE_TYPES);
        for (ProfileVersionPanel$ReleaseTypeCheckBox profileVersionPanel$ReleaseTypeCheckBox : this.customVersionTypes) {
            if (profileVersionPanel$ReleaseTypeCheckBox.isSelected()) {
                hashSet.add(profileVersionPanel$ReleaseTypeCheckBox.getType());
                continue;
            }
            hashSet.remove((Object)profileVersionPanel$ReleaseTypeCheckBox.getType());
        }
        if (((Object)hashSet).equals(Profile.DEFAULT_RELEASE_TYPES)) {
            profile.setAllowedReleaseTypes(null);
        } else {
            profile.setAllowedReleaseTypes(hashSet);
        }
        this.populateVersions(this.editor.getLauncher().getVersionManager().getVersions(this.editor.getProfile().getVersionFilter()));
        this.editor.getLauncher().getVersionManager().removeRefreshedVersionsListener(this);
    }

    private void updateVersionSelection() {
        Object object = this.versionList.getSelectedItem();
        if (object instanceof VersionSyncInfo) {
            object = ((VersionSyncInfo)object).getLatestVersion();
            this.editor.getProfile().setLastVersionId(object.getId());
            return;
        }
        this.editor.getProfile().setLastVersionId(null);
    }

    private void populateVersions(List<VersionSyncInfo> list) {
        String string = this.editor.getProfile().getLastVersionId();
        VersionSyncInfo versionSyncInfo = null;
        this.versionList.removeAllItems();
        this.versionList.addItem("Use Latest Version");
        for (VersionSyncInfo versionSyncInfo2 : list) {
            if (versionSyncInfo2.getLatestVersion().getId().equals(string)) {
                versionSyncInfo = versionSyncInfo2;
            }
            this.versionList.addItem(versionSyncInfo2);
        }
        if (versionSyncInfo == null && !list.isEmpty()) {
            this.versionList.setSelectedIndex(0);
            return;
        }
        this.versionList.setSelectedItem(versionSyncInfo);
    }

    @Override
    public void onVersionsRefreshed(VersionManager object) {
        object = ((VersionManager)object).getVersions(this.editor.getProfile().getVersionFilter());
        this.populateVersions((List<VersionSyncInfo>)object);
        this.editor.getLauncher().getVersionManager().removeRefreshedVersionsListener(this);
    }

    @Override
    public boolean shouldReceiveEventsInUIThread() {
        return true;
    }

    static /* synthetic */ void a(ProfileVersionPanel profileVersionPanel) {
        profileVersionPanel.updateVersionSelection();
    }

    static /* synthetic */ ProfileEditorPopup b(ProfileVersionPanel profileVersionPanel) {
        return profileVersionPanel.editor;
    }

    static /* synthetic */ void c(ProfileVersionPanel profileVersionPanel) {
        profileVersionPanel.updateCustomVersionFilter();
    }
}

