/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.profile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.ui.popups.profile.ProfileEditorPopup;
import net.minecraft.launcher.ui.popups.profile.ProfileJavaPanel$1;
import net.minecraft.launcher.ui.popups.profile.ProfileJavaPanel$2;
import net.minecraft.launcher.ui.popups.profile.ProfileJavaPanel$3;
import net.minecraft.launcher.ui.popups.profile.ProfileJavaPanel$4;

public class ProfileJavaPanel
extends JPanel {
    private final ProfileEditorPopup editor;
    private final JCheckBox javaPathCustom = new JCheckBox("Executable:");
    private final JTextField javaPathField = new JTextField();
    private final JCheckBox javaArgsCustom = new JCheckBox("JVM Arguments:");
    private final JTextField javaArgsField = new JTextField();

    public ProfileJavaPanel(ProfileEditorPopup profileEditorPopup) {
        this.editor = profileEditorPopup;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("Java Settings (Advanced)"));
        this.createInterface();
        this.fillDefaultValues();
        this.addEventHandlers();
    }

    protected void createInterface() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.javaPathCustom, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.javaPathField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.javaArgsCustom, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.javaArgsField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
    }

    protected void fillDefaultValues() {
        String string = this.editor.getProfile().getJavaPath();
        if (string != null) {
            this.javaPathCustom.setSelected(true);
            this.javaPathField.setText(string);
        } else {
            this.javaPathCustom.setSelected(false);
            this.javaPathField.setText(OperatingSystem.getCurrentPlatform().getJavaDir());
        }
        this.updateJavaPathState();
        string = this.editor.getProfile().getJavaArgs();
        if (string != null) {
            this.javaArgsCustom.setSelected(true);
            this.javaArgsField.setText(string);
        } else {
            this.javaArgsCustom.setSelected(false);
            this.javaArgsField.setText("-Xmx1G");
        }
        this.updateJavaArgsState();
    }

    protected void addEventHandlers() {
        this.javaPathCustom.addItemListener(new ProfileJavaPanel$1(this));
        this.javaPathField.getDocument().addDocumentListener(new ProfileJavaPanel$2(this));
        this.javaArgsCustom.addItemListener(new ProfileJavaPanel$3(this));
        this.javaArgsField.getDocument().addDocumentListener(new ProfileJavaPanel$4(this));
    }

    private void updateJavaPath() {
        if (this.javaPathCustom.isSelected()) {
            this.editor.getProfile().setJavaDir(this.javaPathField.getText());
            return;
        }
        this.editor.getProfile().setJavaDir(null);
    }

    private void updateJavaPathState() {
        if (this.javaPathCustom.isSelected()) {
            this.javaPathField.setEnabled(true);
            this.editor.getProfile().setJavaDir(this.javaPathField.getText());
            return;
        }
        this.javaPathField.setEnabled(false);
        this.editor.getProfile().setJavaDir(null);
    }

    private void updateJavaArgs() {
        if (this.javaArgsCustom.isSelected()) {
            this.editor.getProfile().setJavaArgs(this.javaArgsField.getText());
            return;
        }
        this.editor.getProfile().setJavaArgs(null);
    }

    private void updateJavaArgsState() {
        if (this.javaArgsCustom.isSelected()) {
            this.javaArgsField.setEnabled(true);
            this.editor.getProfile().setJavaArgs(this.javaArgsField.getText());
            return;
        }
        this.javaArgsField.setEnabled(false);
        this.editor.getProfile().setJavaArgs(null);
    }

    static /* synthetic */ void a(ProfileJavaPanel profileJavaPanel) {
        profileJavaPanel.updateJavaPathState();
    }

    static /* synthetic */ void b(ProfileJavaPanel profileJavaPanel) {
        profileJavaPanel.updateJavaPath();
    }

    static /* synthetic */ void c(ProfileJavaPanel profileJavaPanel) {
        profileJavaPanel.updateJavaArgsState();
    }

    static /* synthetic */ void d(ProfileJavaPanel profileJavaPanel) {
        profileJavaPanel.updateJavaArgs();
    }
}

