/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.profile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.minecraft.launcher.profile.LauncherVisibilityRule;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.profile.Profile$Resolution;
import net.minecraft.launcher.ui.popups.profile.ProfileEditorPopup;
import net.minecraft.launcher.ui.popups.profile.ProfileInfoPanel$1;
import net.minecraft.launcher.ui.popups.profile.ProfileInfoPanel$2;
import net.minecraft.launcher.ui.popups.profile.ProfileInfoPanel$3;
import net.minecraft.launcher.ui.popups.profile.ProfileInfoPanel$4;
import net.minecraft.launcher.ui.popups.profile.ProfileInfoPanel$5;
import net.minecraft.launcher.ui.popups.profile.ProfileInfoPanel$6;
import net.minecraft.launcher.ui.popups.profile.ProfileInfoPanel$7;
import net.minecraft.launcher.ui.popups.profile.ProfileInfoPanel$8;

public class ProfileInfoPanel
extends JPanel {
    private final ProfileEditorPopup editor;
    private final JCheckBox gameDirCustom = new JCheckBox("Game Directory:");
    private final JTextField profileName = new JTextField();
    private final JTextField gameDirField = new JTextField();
    private final JCheckBox resolutionCustom = new JCheckBox("Resolution:");
    private final JTextField resolutionWidth = new JTextField();
    private final JTextField resolutionHeight = new JTextField();
    private final JCheckBox useHopper = new JCheckBox("Automatically ask Mojang for assistance with fixing crashes");
    private final JCheckBox launcherVisibilityCustom = new JCheckBox("Launcher Visibility:");
    private final JComboBox launcherVisibilityOption = new JComboBox();

    public ProfileInfoPanel(ProfileEditorPopup profileEditorPopup) {
        this.editor = profileEditorPopup;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("Profile Info"));
        this.createInterface();
        this.fillDefaultValues();
        this.addEventHandlers();
    }

    protected void createInterface() {
        LauncherVisibilityRule[] launcherVisibilityRuleArray = new GridBagConstraints();
        new GridBagConstraints().insets = new Insets(2, 2, 2, 2);
        launcherVisibilityRuleArray.anchor = 17;
        launcherVisibilityRuleArray.gridy = 0;
        this.add((Component)new JLabel("Profile Name:"), launcherVisibilityRuleArray);
        launcherVisibilityRuleArray.fill = 2;
        launcherVisibilityRuleArray.weightx = 1.0;
        this.add((Component)this.profileName, launcherVisibilityRuleArray);
        launcherVisibilityRuleArray.weightx = 0.0;
        launcherVisibilityRuleArray.fill = 0;
        ++launcherVisibilityRuleArray.gridy;
        this.add((Component)this.gameDirCustom, launcherVisibilityRuleArray);
        launcherVisibilityRuleArray.fill = 2;
        launcherVisibilityRuleArray.weightx = 1.0;
        this.add((Component)this.gameDirField, launcherVisibilityRuleArray);
        launcherVisibilityRuleArray.weightx = 0.0;
        launcherVisibilityRuleArray.fill = 0;
        ++launcherVisibilityRuleArray.gridy;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.resolutionWidth);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(new JLabel("x"));
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.resolutionHeight);
        this.add((Component)this.resolutionCustom, launcherVisibilityRuleArray);
        launcherVisibilityRuleArray.fill = 2;
        launcherVisibilityRuleArray.weightx = 1.0;
        this.add((Component)jPanel, launcherVisibilityRuleArray);
        launcherVisibilityRuleArray.weightx = 0.0;
        launcherVisibilityRuleArray.fill = 0;
        ++launcherVisibilityRuleArray.gridy;
        launcherVisibilityRuleArray.fill = 2;
        launcherVisibilityRuleArray.weightx = 1.0;
        launcherVisibilityRuleArray.gridwidth = 0;
        this.add((Component)this.useHopper, launcherVisibilityRuleArray);
        launcherVisibilityRuleArray.gridwidth = 1;
        launcherVisibilityRuleArray.weightx = 0.0;
        launcherVisibilityRuleArray.fill = 0;
        ++launcherVisibilityRuleArray.gridy;
        this.add((Component)this.launcherVisibilityCustom, launcherVisibilityRuleArray);
        launcherVisibilityRuleArray.fill = 2;
        launcherVisibilityRuleArray.weightx = 1.0;
        this.add((Component)this.launcherVisibilityOption, launcherVisibilityRuleArray);
        launcherVisibilityRuleArray.weightx = 0.0;
        launcherVisibilityRuleArray.fill = 0;
        ++launcherVisibilityRuleArray.gridy;
        for (LauncherVisibilityRule launcherVisibilityRule : LauncherVisibilityRule.values()) {
            this.launcherVisibilityOption.addItem(launcherVisibilityRule);
        }
    }

    protected void fillDefaultValues() {
        this.profileName.setText(this.editor.getProfile().getName());
        Object object = this.editor.getProfile().getGameDir();
        if (object != null) {
            this.gameDirCustom.setSelected(true);
            this.gameDirField.setText(((File)object).getAbsolutePath());
        } else {
            this.gameDirCustom.setSelected(false);
            this.gameDirField.setText(this.editor.getLauncher().getWorkingDirectory().getAbsolutePath());
        }
        this.updateGameDirState();
        object = this.editor.getProfile().getResolution();
        this.resolutionCustom.setSelected(object != null);
        if (object == null) {
            object = Profile.DEFAULT_RESOLUTION;
        }
        this.resolutionWidth.setText(String.valueOf(((Profile$Resolution)object).getWidth()));
        this.resolutionHeight.setText(String.valueOf(((Profile$Resolution)object).getHeight()));
        this.updateResolutionState();
        this.useHopper.setSelected(this.editor.getProfile().getUseHopperCrashService());
        object = this.editor.getProfile().getLauncherVisibilityOnGameClose();
        if (object != null) {
            this.launcherVisibilityCustom.setSelected(true);
            this.launcherVisibilityOption.setSelectedItem(object);
        } else {
            this.launcherVisibilityCustom.setSelected(false);
            this.launcherVisibilityOption.setSelectedItem((Object)Profile.DEFAULT_LAUNCHER_VISIBILITY);
        }
        this.updateLauncherVisibilityState();
    }

    protected void addEventHandlers() {
        this.profileName.getDocument().addDocumentListener(new ProfileInfoPanel$1(this));
        this.gameDirCustom.addItemListener(new ProfileInfoPanel$2(this));
        this.gameDirField.getDocument().addDocumentListener(new ProfileInfoPanel$3(this));
        this.resolutionCustom.addItemListener(new ProfileInfoPanel$4(this));
        ProfileInfoPanel$5 profileInfoPanel$5 = new ProfileInfoPanel$5(this);
        this.resolutionWidth.getDocument().addDocumentListener(profileInfoPanel$5);
        this.resolutionHeight.getDocument().addDocumentListener(profileInfoPanel$5);
        this.useHopper.addItemListener(new ProfileInfoPanel$6(this));
        this.launcherVisibilityCustom.addItemListener(new ProfileInfoPanel$7(this));
        this.launcherVisibilityOption.addItemListener(new ProfileInfoPanel$8(this));
    }

    private void updateLauncherVisibilityState() {
        Profile profile = this.editor.getProfile();
        if (this.launcherVisibilityCustom.isSelected() && this.launcherVisibilityOption.getSelectedItem() instanceof LauncherVisibilityRule) {
            profile.setLauncherVisibilityOnGameClose((LauncherVisibilityRule)((Object)this.launcherVisibilityOption.getSelectedItem()));
            this.launcherVisibilityOption.setEnabled(true);
            return;
        }
        profile.setLauncherVisibilityOnGameClose(null);
        this.launcherVisibilityOption.setEnabled(false);
    }

    private void updateLauncherVisibilitySelection() {
        Profile profile = this.editor.getProfile();
        if (this.launcherVisibilityOption.getSelectedItem() instanceof LauncherVisibilityRule) {
            profile.setLauncherVisibilityOnGameClose((LauncherVisibilityRule)((Object)this.launcherVisibilityOption.getSelectedItem()));
        }
    }

    private void updateHopper() {
        Profile profile = this.editor.getProfile();
        if (this.useHopper.isSelected()) {
            profile.setUseHopperCrashService(true);
            return;
        }
        profile.setUseHopperCrashService(false);
    }

    private void updateProfileName() {
        if (this.profileName.getText().length() > 0) {
            this.editor.getProfile().setName(this.profileName.getText());
        }
    }

    private void updateGameDirState() {
        if (this.gameDirCustom.isSelected()) {
            this.gameDirField.setEnabled(true);
            this.editor.getProfile().setGameDir(new File(this.gameDirField.getText()));
            return;
        }
        this.gameDirField.setEnabled(false);
        this.editor.getProfile().setGameDir(null);
    }

    private void updateResolutionState() {
        if (this.resolutionCustom.isSelected()) {
            this.resolutionWidth.setEnabled(true);
            this.resolutionHeight.setEnabled(true);
            this.updateResolution();
            return;
        }
        this.resolutionWidth.setEnabled(false);
        this.resolutionHeight.setEnabled(false);
        this.editor.getProfile().setResolution(null);
    }

    private void updateResolution() {
        try {
            int n2 = Integer.parseInt(this.resolutionWidth.getText());
            int n3 = Integer.parseInt(this.resolutionHeight.getText());
            this.editor.getProfile().setResolution(new Profile$Resolution(n2, n3));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.editor.getProfile().setResolution(null);
            return;
        }
    }

    private void updateGameDir() {
        File file = new File(this.gameDirField.getText());
        this.editor.getProfile().setGameDir(file);
    }

    static /* synthetic */ void a(ProfileInfoPanel profileInfoPanel) {
        profileInfoPanel.updateProfileName();
    }

    static /* synthetic */ void b(ProfileInfoPanel profileInfoPanel) {
        profileInfoPanel.updateGameDirState();
    }

    static /* synthetic */ void c(ProfileInfoPanel profileInfoPanel) {
        profileInfoPanel.updateGameDir();
    }

    static /* synthetic */ void d(ProfileInfoPanel profileInfoPanel) {
        profileInfoPanel.updateResolutionState();
    }

    static /* synthetic */ void e(ProfileInfoPanel profileInfoPanel) {
        profileInfoPanel.updateResolution();
    }

    static /* synthetic */ void f(ProfileInfoPanel profileInfoPanel) {
        profileInfoPanel.updateHopper();
    }

    static /* synthetic */ void g(ProfileInfoPanel profileInfoPanel) {
        profileInfoPanel.updateLauncherVisibilityState();
    }

    static /* synthetic */ void h(ProfileInfoPanel profileInfoPanel) {
        profileInfoPanel.updateLauncherVisibilitySelection();
    }
}

