/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.EventObject;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.profile.ProfileManager;
import net.minecraft.launcher.ui.popups.profile.ProfileInfoPanel;
import net.minecraft.launcher.ui.popups.profile.ProfileJavaPanel;
import net.minecraft.launcher.ui.popups.profile.ProfileVersionPanel;

public class ProfileEditorPopup
extends JPanel
implements ActionListener {
    private final Launcher launcher;
    private final Profile originalProfile;
    private final Profile profile;
    private final JButton saveButton = new JButton("Save Profile");
    private final JButton cancelButton = new JButton("Cancel");
    private final ProfileInfoPanel profileInfoPanel;
    private final ProfileVersionPanel profileVersionPanel;
    private final ProfileJavaPanel javaInfoPanel;

    public ProfileEditorPopup(Launcher launcher, Profile profile) {
        super(true);
        this.launcher = launcher;
        this.originalProfile = profile;
        this.profile = new Profile(profile);
        this.profileInfoPanel = new ProfileInfoPanel(this);
        this.profileVersionPanel = new ProfileVersionPanel(this);
        this.javaInfoPanel = new ProfileJavaPanel(this);
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(0, 5));
        this.createInterface();
    }

    protected void createInterface() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.profileInfoPanel);
        jPanel.add(this.profileVersionPanel);
        jPanel.add(this.javaInfoPanel);
        this.add((Component)jPanel, "Center");
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.cancelButton);
        jPanel.add(Box.createGlue());
        jPanel.add(this.saveButton);
        this.add((Component)jPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if (((EventObject)object).getSource() == this.saveButton) {
            try {
                object = this.launcher.getProfileManager();
                Map<String, Profile> map = ((ProfileManager)object).getProfiles();
                if (!this.originalProfile.getName().equals(this.profile.getName())) {
                    map.remove(this.originalProfile.getName());
                    while (map.containsKey(this.profile.getName())) {
                        this.profile.setName(this.profile.getName() + "_");
                    }
                }
                map.put(this.profile.getName(), this.profile);
                ((ProfileManager)object).saveProfiles();
                ((ProfileManager)object).fireRefreshEvent();
            }
            catch (IOException iOException) {
                this.launcher.println("Couldn't save profiles whilst editing " + this.profile.getName(), iOException);
            }
        }
        object = (Window)this.getTopLevelAncestor();
        ((Component)object).dispatchEvent(new WindowEvent((Window)object, 201));
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public static void showEditProfileDialog(Launcher launcher, Profile object) {
        JDialog jDialog = new JDialog(launcher.getFrame(), "Profile Editor", true);
        object = new ProfileEditorPopup(launcher, (Profile)object);
        jDialog.add((Component)object);
        jDialog.pack();
        jDialog.setLocationRelativeTo(launcher.getFrame());
        jDialog.setVisible(true);
    }
}

