/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.login;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.LauncherConstants;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.ui.popups.login.AuthErrorForm;
import net.minecraft.launcher.ui.popups.login.ExistingUserListForm;
import net.minecraft.launcher.ui.popups.login.LogInForm;
import net.minecraft.launcher.ui.popups.login.LogInPopup$1;
import net.minecraft.launcher.ui.popups.login.LogInPopup$2;
import net.minecraft.launcher.ui.popups.login.LogInPopup$Callback;

public class LogInPopup
extends JPanel
implements ActionListener {
    private final Launcher launcher;
    private final LogInPopup$Callback callback;
    private final AuthErrorForm errorForm;
    private final ExistingUserListForm existingUserListForm;
    private final LogInForm logInForm;
    private final JButton loginButton = new JButton("Log In");
    private final JButton registerButton = new JButton("Register");
    private final JProgressBar progressBar = new JProgressBar();

    public LogInPopup(Launcher launcher, LogInPopup$Callback logInPopup$Callback) {
        super(true);
        this.launcher = launcher;
        this.callback = logInPopup$Callback;
        this.errorForm = new AuthErrorForm(this);
        this.existingUserListForm = new ExistingUserListForm(this);
        this.logInForm = new LogInForm(this);
        this.createInterface();
        this.loginButton.addActionListener(this);
        this.registerButton.addActionListener(this);
    }

    protected void createInterface() {
        Object object;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(5, 15, 5, 15));
        try {
            object = LogInPopup.class.getResourceAsStream("/minecraft_logo.png");
            if (object != null) {
                object = ImageIO.read((InputStream)object);
                object = new JLabel(new ImageIcon((Image)object));
                JPanel jPanel = new JPanel();
                jPanel.add((Component)object);
                this.add(jPanel);
                this.add(Box.createVerticalStrut(10));
            }
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        if (!this.launcher.getProfileManager().getAuthDatabase().getKnownNames().isEmpty()) {
            this.add(this.existingUserListForm);
        }
        this.add(this.errorForm);
        this.add(this.logInForm);
        this.add(Box.createVerticalStrut(15));
        object = new JPanel();
        ((Container)object).setLayout(new GridLayout(1, 2, 10, 0));
        ((Container)object).add(this.registerButton);
        ((Container)object).add(this.loginButton);
        this.add((Component)object);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        this.add(this.progressBar);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.loginButton) {
            this.logInForm.tryLogIn();
            return;
        }
        if (actionEvent.getSource() == this.registerButton) {
            OperatingSystem.openLink(LauncherConstants.URL_REGISTER);
        }
    }

    public static void showLoginPrompt(Launcher launcher, LogInPopup$Callback logInPopup$Callback) {
        SwingUtilities.invokeLater(new LogInPopup$1(launcher, logInPopup$Callback));
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public void setCanLogIn(boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.loginButton.setEnabled(bl);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setIndeterminate(true);
            this.progressBar.setVisible(!bl);
            this.repack();
            return;
        }
        SwingUtilities.invokeLater(new LogInPopup$2(this, bl));
    }

    public LogInForm getLogInForm() {
        return this.logInForm;
    }

    public AuthErrorForm getErrorForm() {
        return this.errorForm;
    }

    public ExistingUserListForm getExistingUserListForm() {
        return this.existingUserListForm;
    }

    public void setLoggedIn(String string) {
        this.callback.onLogIn(string);
    }

    public void repack() {
        Window window = SwingUtilities.windowForComponent(this);
        if (window != null) {
            window.pack();
        }
    }
}

