/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.login;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.authentication.GameProfile;
import net.minecraft.launcher.authentication.yggdrasil.YggdrasilAuthenticationService;
import net.minecraft.launcher.ui.popups.login.LogInForm$1;
import net.minecraft.launcher.ui.popups.login.LogInForm$2;
import net.minecraft.launcher.ui.popups.login.LogInForm$3;
import net.minecraft.launcher.ui.popups.login.LogInForm$4;
import net.minecraft.launcher.ui.popups.login.LogInPopup;
import org.apache.commons.lang3.ArrayUtils;

public class LogInForm
extends JPanel
implements ActionListener {
    private final LogInPopup popup;
    private final JTextField usernameField = new JTextField();
    private final JPasswordField passwordField = new JPasswordField();
    private final JComboBox userDropdown = new JComboBox();
    private final JPanel userDropdownPanel = new JPanel();
    private final AuthenticationService authentication = new YggdrasilAuthenticationService();

    public LogInForm(LogInPopup logInPopup) {
        this.popup = logInPopup;
        this.usernameField.addActionListener(this);
        this.passwordField.addActionListener(this);
        this.createInterface();
    }

    protected void createInterface() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 1.0;
        this.add(Box.createGlue());
        JLabel jLabel = new JLabel("Email Address or Username:");
        Font font = jLabel.getFont().deriveFont(1);
        Font font2 = jLabel.getFont().deriveFont((float)font.getSize() - 2.0f);
        jLabel.setFont(font);
        this.add((Component)jLabel, gridBagConstraints);
        this.add((Component)this.usernameField, gridBagConstraints);
        jLabel = new JLabel("(Which do I use?)");
        jLabel.setFont(font2);
        jLabel.setHorizontalAlignment(4);
        jLabel.addMouseListener(new LogInForm$1(this));
        this.add((Component)jLabel, gridBagConstraints);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
        jLabel = new JLabel("Password:");
        jLabel.setFont(font);
        this.add((Component)jLabel, gridBagConstraints);
        this.add((Component)this.passwordField, gridBagConstraints);
        jLabel = new JLabel("(Forgot Password?)");
        jLabel.setFont(font2);
        jLabel.setHorizontalAlignment(4);
        jLabel.addMouseListener(new LogInForm$2(this));
        this.add((Component)jLabel, gridBagConstraints);
        this.createUserDropdownPanel(font);
        this.add((Component)this.userDropdownPanel, gridBagConstraints);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
    }

    protected void createUserDropdownPanel(Font font) {
        this.userDropdownPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 1.0;
        this.userDropdownPanel.add(Box.createVerticalStrut(8), gridBagConstraints);
        JLabel jLabel = new JLabel("Character Name:");
        jLabel.setFont(font);
        this.userDropdownPanel.add((Component)jLabel, gridBagConstraints);
        this.userDropdownPanel.add((Component)this.userDropdown, gridBagConstraints);
        this.userDropdownPanel.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.usernameField || actionEvent.getSource() == this.passwordField) {
            this.tryLogIn();
        }
    }

    public void tryLogIn() {
        if (this.authentication.isLoggedIn() && this.authentication.getSelectedProfile() == null && ArrayUtils.isNotEmpty(this.authentication.getAvailableProfiles())) {
            this.popup.setCanLogIn(false);
            GameProfile gameProfile = null;
            for (GameProfile gameProfile2 : this.authentication.getAvailableProfiles()) {
                if (!gameProfile2.getName().equals(this.userDropdown.getSelectedItem())) continue;
                gameProfile = gameProfile2;
                break;
            }
            if (gameProfile == null) {
                gameProfile = this.authentication.getAvailableProfiles()[0];
            }
            GameProfile[] gameProfileArray = gameProfile;
            this.popup.getLauncher().getVersionManager().getExecutorService().execute(new LogInForm$3(this, (GameProfile)gameProfileArray));
            return;
        }
        this.popup.setCanLogIn(false);
        this.authentication.logOut();
        this.authentication.setUsername(this.usernameField.getText());
        this.authentication.setPassword(String.valueOf(this.passwordField.getPassword()));
        int n2 = this.passwordField.getPassword().length;
        this.passwordField.setText("");
        this.popup.getLauncher().getVersionManager().getExecutorService().execute(new LogInForm$4(this, n2));
    }

    static /* synthetic */ AuthenticationService a(LogInForm logInForm) {
        return logInForm.authentication;
    }

    static /* synthetic */ LogInPopup b(LogInForm logInForm) {
        return logInForm.popup;
    }

    static /* synthetic */ JComboBox c(LogInForm logInForm) {
        return logInForm.userDropdown;
    }

    static /* synthetic */ JTextField d(LogInForm logInForm) {
        return logInForm.usernameField;
    }

    static /* synthetic */ JPasswordField e(LogInForm logInForm) {
        return logInForm.passwordField;
    }

    static /* synthetic */ JPanel f(LogInForm logInForm) {
        return logInForm.userDropdownPanel;
    }
}

