/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.login;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.minecraft.launcher.authentication.AuthenticationDatabase;
import net.minecraft.launcher.ui.popups.login.ExistingUserListForm$1;
import net.minecraft.launcher.ui.popups.login.LogInPopup;

public class ExistingUserListForm
extends JPanel
implements ActionListener {
    private final LogInPopup popup;
    private final JComboBox userDropdown = new JComboBox();
    private final AuthenticationDatabase authDatabase;
    private final JButton playButton = new JButton("Play");

    public ExistingUserListForm(LogInPopup logInPopup) {
        this.popup = logInPopup;
        this.authDatabase = logInPopup.getLauncher().getProfileManager().getAuthDatabase();
        this.fillUsers();
        this.createInterface();
        this.playButton.addActionListener(this);
    }

    private void fillUsers() {
        for (String string : this.authDatabase.getKnownNames()) {
            this.userDropdown.addItem(string);
        }
    }

    protected void createInterface() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(Box.createGlue());
        Object object = this.authDatabase.getKnownNames().size() == 1 ? this.authDatabase.getKnownNames().iterator().next() : this.authDatabase.getKnownNames().size() + " different users";
        Object object2 = this.authDatabase.getKnownNames().size() == 1 ? "this account" : "one of these accounts";
        this.add((Component)new JLabel("You're already logged in as " + (String)object + "."), gridBagConstraints);
        this.add((Component)new JLabel("You may use " + (String)object2 + " and skip authentication."), gridBagConstraints);
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        object = new JLabel("Existing User:");
        object2 = ((Component)object).getFont().deriveFont(1);
        ((JComponent)object).setFont((Font)object2);
        this.add((Component)object, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.userDropdown, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.playButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 2;
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        this.add((Component)new JLabel("Alternatively, log in with a new account below:"), gridBagConstraints);
        this.add((Component)new JPopupMenu.Separator(), gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.playButton) {
            this.popup.setCanLogIn(false);
            this.popup.getLauncher().getVersionManager().getExecutorService().execute(new ExistingUserListForm$1(this));
        }
    }

    static /* synthetic */ JComboBox a(ExistingUserListForm existingUserListForm) {
        return existingUserListForm.userDropdown;
    }

    static /* synthetic */ AuthenticationDatabase b(ExistingUserListForm existingUserListForm) {
        return existingUserListForm.authDatabase;
    }

    static /* synthetic */ LogInPopup c(ExistingUserListForm existingUserListForm) {
        return existingUserListForm.popup;
    }
}

