/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.bottombar;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Collection;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.events.RefreshedProfilesListener;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.profile.ProfileManager;
import net.minecraft.launcher.ui.bottombar.ProfileSelectionPanel$ProfileListRenderer;
import net.minecraft.launcher.ui.popups.profile.ProfileEditorPopup;

public class ProfileSelectionPanel
extends JPanel
implements ActionListener,
ItemListener,
RefreshedProfilesListener {
    private final JComboBox profileList = new JComboBox();
    private final JButton newProfileButton = new JButton("New Profile");
    private final JButton editProfileButton = new JButton("Edit Profile");
    private final Launcher launcher;
    private boolean skipSelectionUpdate;

    public ProfileSelectionPanel(Launcher launcher) {
        this.launcher = launcher;
        this.profileList.setRenderer(new ProfileSelectionPanel$ProfileListRenderer());
        this.profileList.addItemListener(this);
        this.profileList.addItem("Loading profiles...");
        this.newProfileButton.addActionListener(this);
        this.editProfileButton.addActionListener(this);
        this.createInterface();
        launcher.getProfileManager().addRefreshedProfilesListener(this);
    }

    protected void createInterface() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 0;
        this.add((Component)new JLabel("Profile: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.profileList, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setBorder(new EmptyBorder(2, 0, 0, 0));
        jPanel.add(this.newProfileButton);
        jPanel.add(this.editProfileButton);
        gridBagConstraints.gridwidth = 2;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
    }

    @Override
    public void onProfilesRefreshed(ProfileManager profileManager) {
        this.populateProfiles();
    }

    @Override
    public boolean shouldReceiveEventsInUIThread() {
        return true;
    }

    public void populateProfiles() {
        String string = this.launcher.getProfileManager().getSelectedProfile().getName();
        Profile profile = null;
        Collection<Profile> collection = this.launcher.getProfileManager().getProfiles().values();
        this.profileList.removeAllItems();
        this.skipSelectionUpdate = true;
        for (Profile profile2 : collection) {
            if (string.equals(profile2.getName())) {
                profile = profile2;
            }
            this.profileList.addItem(profile2);
        }
        if (profile == null) {
            if (collection.isEmpty()) {
                profile = this.launcher.getProfileManager().getSelectedProfile();
                this.profileList.addItem(profile);
            }
            profile = collection.iterator().next();
        }
        this.profileList.setSelectedItem(profile);
        this.skipSelectionUpdate = false;
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() != 1) {
            return;
        }
        if (!this.skipSelectionUpdate && ((ItemEvent)object).getItem() instanceof Profile) {
            object = (Profile)((ItemEvent)object).getItem();
            this.launcher.getProfileManager().setSelectedProfile(((Profile)object).getName());
            try {
                this.launcher.getProfileManager().saveProfiles();
            }
            catch (IOException iOException) {
                this.launcher.println("Couldn't save new selected profile", iOException);
            }
            this.launcher.ensureLoggedIn();
        }
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if (((EventObject)object).getSource() == this.newProfileButton) {
            object = new Profile(this.launcher.getProfileManager().getSelectedProfile());
            ((Profile)object).setName("Copy of " + ((Profile)object).getName());
            while (this.launcher.getProfileManager().getProfiles().containsKey(((Profile)object).getName())) {
                ((Profile)object).setName(((Profile)object).getName() + "_");
            }
            ProfileEditorPopup.showEditProfileDialog(this.getLauncher(), (Profile)object);
            this.launcher.getProfileManager().setSelectedProfile(((Profile)object).getName());
            return;
        }
        if (((EventObject)object).getSource() == this.editProfileButton) {
            object = this.launcher.getProfileManager().getSelectedProfile();
            ProfileEditorPopup.showEditProfileDialog(this.getLauncher(), (Profile)object);
        }
    }

    public Launcher getLauncher() {
        return this.launcher;
    }
}

