/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.bottombar;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.events.RefreshedProfilesListener;
import net.minecraft.launcher.events.RefreshedVersionsListener;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.profile.ProfileManager;
import net.minecraft.launcher.ui.bottombar.PlayerInfoPanel$1;
import net.minecraft.launcher.updater.VersionManager;
import net.minecraft.launcher.updater.VersionSyncInfo;

public class PlayerInfoPanel
extends JPanel
implements RefreshedProfilesListener,
RefreshedVersionsListener {
    private final Launcher launcher;
    private final JLabel welcomeText = new JLabel("", 0);
    private final JLabel versionText = new JLabel("", 0);
    private final JButton logOutButton = new JButton("Log Out");

    public PlayerInfoPanel(Launcher launcher) {
        this.launcher = launcher;
        launcher.getProfileManager().addRefreshedProfilesListener(this);
        this.checkState();
        this.createInterface();
        this.logOutButton.addActionListener(new PlayerInfoPanel$1(this, launcher));
    }

    protected void createInterface() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.welcomeText, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.versionText, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 0;
        this.add((Component)this.logOutButton, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
    }

    @Override
    public void onProfilesRefreshed(ProfileManager profileManager) {
        this.checkState();
    }

    public void checkState() {
        Object object = this.launcher.getProfileManager().getProfiles().isEmpty() ? null : this.launcher.getProfileManager().getSelectedProfile();
        AuthenticationService authenticationService = object == null ? null : this.launcher.getProfileManager().getAuthDatabase().getByUUID(((Profile)object).getPlayerUUID());
        Object object2 = object == null ? null : this.launcher.getVersionManager().getVersions(((Profile)object).getVersionFilter());
        Object object3 = object2 = object == null || object2.isEmpty() ? null : object2.get(0);
        if (object != null && ((Profile)object).getLastVersionId() != null && (object = this.launcher.getVersionManager().getVersionSyncInfo(((Profile)object).getLastVersionId())) != null && ((VersionSyncInfo)object).getLatestVersion() != null) {
            object2 = object;
        }
        if (authenticationService == null || !authenticationService.isLoggedIn()) {
            this.welcomeText.setText("Welcome, guest! Please log in.");
            this.logOutButton.setEnabled(false);
        } else if (authenticationService.getSelectedProfile() == null) {
            this.welcomeText.setText("<html>Welcome, player!</html>");
            this.logOutButton.setEnabled(true);
        } else {
            this.welcomeText.setText("<html>Welcome, <b>" + authenticationService.getSelectedProfile().getName() + "</b></html>");
            this.logOutButton.setEnabled(true);
        }
        if (object2 == null) {
            this.versionText.setText("Loading versions...");
            return;
        }
        if (((VersionSyncInfo)object2).isUpToDate()) {
            this.versionText.setText("Ready to play Minecraft " + ((VersionSyncInfo)object2).getLatestVersion().getId());
            return;
        }
        if (((VersionSyncInfo)object2).isInstalled()) {
            this.versionText.setText("Ready to update & play Minecraft " + ((VersionSyncInfo)object2).getLatestVersion().getId());
            return;
        }
        if (((VersionSyncInfo)object2).isOnRemote()) {
            this.versionText.setText("Ready to download & play Minecraft " + ((VersionSyncInfo)object2).getLatestVersion().getId());
        }
    }

    @Override
    public void onVersionsRefreshed(VersionManager versionManager) {
        this.checkState();
    }

    @Override
    public boolean shouldReceiveEventsInUIThread() {
        return true;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }
}

