/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.bottombar;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.events.RefreshedProfilesListener;
import net.minecraft.launcher.events.RefreshedVersionsListener;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.profile.ProfileManager;
import net.minecraft.launcher.ui.bottombar.PlayButtonPanel$1;
import net.minecraft.launcher.updater.VersionManager;

public class PlayButtonPanel
extends JPanel
implements RefreshedProfilesListener,
RefreshedVersionsListener {
    private final Launcher launcher;
    private final JButton playButton = new JButton("Play");

    public PlayButtonPanel(Launcher launcher) {
        this.launcher = launcher;
        launcher.getProfileManager().addRefreshedProfilesListener(this);
        this.checkState();
        this.createInterface();
        this.playButton.addActionListener(new PlayButtonPanel$1(this));
    }

    protected void createInterface() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.playButton, gridBagConstraints);
        this.playButton.setFont(this.playButton.getFont().deriveFont(1, this.playButton.getFont().getSize() + 2));
    }

    @Override
    public void onProfilesRefreshed(ProfileManager profileManager) {
        this.checkState();
    }

    public void checkState() {
        Profile profile = this.launcher.getProfileManager().getProfiles().isEmpty() ? null : this.launcher.getProfileManager().getSelectedProfile();
        AuthenticationService authenticationService = profile == null ? null : this.launcher.getProfileManager().getAuthDatabase().getByUUID(profile.getPlayerUUID());
        if (authenticationService == null || !authenticationService.isLoggedIn() || this.launcher.getVersionManager().getVersions(profile.getVersionFilter()).isEmpty()) {
            this.playButton.setEnabled(false);
            this.playButton.setText("Play");
        } else if (authenticationService.getSelectedProfile() == null) {
            this.playButton.setEnabled(true);
            this.playButton.setText("Play Demo");
        } else if (authenticationService.canPlayOnline()) {
            this.playButton.setEnabled(true);
            this.playButton.setText("Play");
        } else {
            this.playButton.setEnabled(true);
            this.playButton.setText("Play Offline");
        }
        if (this.launcher.getGameLauncher().isWorking()) {
            this.playButton.setEnabled(false);
        }
    }

    @Override
    public void onVersionsRefreshed(VersionManager versionManager) {
        this.checkState();
    }

    @Override
    public boolean shouldReceiveEventsInUIThread() {
        return true;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }
}

