/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import net.minecraft.launcher.Launcher;

public class TexturedPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Image image;
    private Image bgImage;

    public TexturedPanel(String string) {
        this.setOpaque(true);
        try {
            this.bgImage = ImageIO.read(TexturedPanel.class.getResource(string)).getScaledInstance(32, 32, 16);
            return;
        }
        catch (IOException iOException) {
            Launcher.getInstance().println("Unexpected exception initializing textured panel", iOException);
            return;
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n2 = this.getWidth() / 2 + 1;
        int n3 = this.getHeight() / 2 + 1;
        if (this.image == null || this.image.getWidth(null) != n2 || this.image.getHeight(null) != n3) {
            this.image = this.createImage(n2, n3);
            this.copyImage(n2, n3);
        }
        graphics.drawImage(this.image, 0, 0, n2 << 1, n3 << 1, null);
    }

    protected void copyImage(int n2, int n3) {
        Graphics graphics = this.image.getGraphics();
        for (int i2 = 0; i2 <= n2 / 32; ++i2) {
            for (int i3 = 0; i3 <= n3 / 32; ++i3) {
                graphics.drawImage(this.bgImage, i2 << 5, i3 << 5, null);
            }
        }
        if (graphics instanceof Graphics2D) {
            this.overlayGradient(n2, n3, (Graphics2D)graphics);
        }
        graphics.dispose();
    }

    protected void overlayGradient(int n2, int n3, Graphics2D graphics2D) {
        graphics2D.setPaint(new GradientPaint(new Point2D.Float(0.0f, 0.0f), new Color(0x20FFFFFF, true), new Point2D.Float(0.0f, 1.0f), new Color(0, true)));
        graphics2D.fillRect(0, 0, n2, 1);
        graphics2D.setPaint(new GradientPaint(new Point2D.Float(0.0f, 0.0f), new Color(0, true), new Point2D.Float(0.0f, n3), new Color(0x60000000, true)));
        graphics2D.fillRect(0, 0, n2, n3);
    }
}

