/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.profile;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.AuthenticationDatabase;
import net.minecraft.launcher.authentication.AuthenticationDatabase$Serializer;
import net.minecraft.launcher.events.RefreshedProfilesListener;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.profile.ProfileManager$1;
import net.minecraft.launcher.profile.ProfileManager$RawProfileList;
import net.minecraft.launcher.updater.DateTypeAdapter;
import net.minecraft.launcher.updater.FileTypeAdapter;
import net.minecraft.launcher.updater.LowerCaseEnumTypeAdapterFactory;
import org.apache.commons.io.FileUtils;

public class ProfileManager {
    public static final String DEFAULT_PROFILE_NAME = "(Default)";
    private final Launcher launcher;
    private final Gson gson;
    private final Map<String, Profile> profiles = new HashMap<String, Profile>();
    private final File profileFile;
    private final List<RefreshedProfilesListener> refreshedProfilesListeners = Collections.synchronizedList(new ArrayList());
    private String selectedProfile;
    private AuthenticationDatabase authDatabase = new AuthenticationDatabase();

    public ProfileManager(Launcher object) {
        this.launcher = object;
        this.profileFile = new File(((Launcher)object).getWorkingDirectory(), "launcher_profiles.json");
        object = new GsonBuilder();
        ((GsonBuilder)object).registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        ((GsonBuilder)object).registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        ((GsonBuilder)object).registerTypeAdapter((Type)((Object)File.class), new FileTypeAdapter());
        ((GsonBuilder)object).registerTypeAdapter((Type)((Object)AuthenticationDatabase.class), new AuthenticationDatabase$Serializer());
        ((GsonBuilder)object).setPrettyPrinting();
        this.gson = ((GsonBuilder)object).create();
    }

    public void saveProfiles() {
        ProfileManager$RawProfileList profileManager$RawProfileList = new ProfileManager$RawProfileList();
        new ProfileManager$RawProfileList().profiles = this.profiles;
        profileManager$RawProfileList.selectedProfile = this.getSelectedProfile().getName();
        profileManager$RawProfileList.clientToken = this.launcher.getClientToken();
        profileManager$RawProfileList.authenticationDatabase = this.authDatabase;
        FileUtils.writeStringToFile(this.profileFile, this.gson.toJson(profileManager$RawProfileList));
    }

    public boolean loadProfiles() {
        this.profiles.clear();
        this.selectedProfile = null;
        if (this.profileFile.isFile()) {
            ProfileManager$RawProfileList profileManager$RawProfileList = this.gson.fromJson(FileUtils.readFileToString(this.profileFile), ProfileManager$RawProfileList.class);
            this.profiles.putAll(profileManager$RawProfileList.profiles);
            this.selectedProfile = profileManager$RawProfileList.selectedProfile;
            this.authDatabase = profileManager$RawProfileList.authenticationDatabase;
            this.launcher.setClientToken(profileManager$RawProfileList.clientToken);
            this.fireRefreshEvent();
            return true;
        }
        this.fireRefreshEvent();
        return false;
    }

    public void fireRefreshEvent() {
        ArrayList<RefreshedProfilesListener> arrayList = new ArrayList<RefreshedProfilesListener>(this.refreshedProfilesListeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RefreshedProfilesListener refreshedProfilesListener = (RefreshedProfilesListener)iterator.next();
            if (refreshedProfilesListener.shouldReceiveEventsInUIThread()) continue;
            refreshedProfilesListener.onProfilesRefreshed(this);
            iterator.remove();
        }
        if (!arrayList.isEmpty()) {
            SwingUtilities.invokeLater(new ProfileManager$1(this, arrayList));
        }
    }

    public Profile getSelectedProfile() {
        if (this.selectedProfile == null || !this.profiles.containsKey(this.selectedProfile)) {
            if (this.profiles.get(DEFAULT_PROFILE_NAME) != null) {
                this.selectedProfile = DEFAULT_PROFILE_NAME;
            } else if (this.profiles.size() > 0) {
                this.selectedProfile = this.profiles.values().iterator().next().getName();
            } else {
                this.selectedProfile = DEFAULT_PROFILE_NAME;
                this.profiles.put(DEFAULT_PROFILE_NAME, new Profile(this.selectedProfile));
            }
        }
        return this.profiles.get(this.selectedProfile);
    }

    public Map<String, Profile> getProfiles() {
        return this.profiles;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public void addRefreshedProfilesListener(RefreshedProfilesListener refreshedProfilesListener) {
        this.refreshedProfilesListeners.add(refreshedProfilesListener);
    }

    public void setSelectedProfile(String string) {
        boolean bl = !this.selectedProfile.equals(string);
        this.selectedProfile = string;
        if (bl) {
            this.fireRefreshEvent();
        }
    }

    public AuthenticationDatabase getAuthDatabase() {
        return this.authDatabase;
    }

    public void trimAuthDatabase() {
        HashSet<String> hashSet = new HashSet<String>(this.authDatabase.getknownUUIDs());
        for (Profile object : this.profiles.values()) {
            hashSet.remove(object.getPlayerUUID());
        }
        for (String string : hashSet) {
            this.authDatabase.removeUUID(string);
        }
    }
}

