/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.profile;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.launcher.profile.LauncherVisibilityRule;
import net.minecraft.launcher.profile.Profile$Resolution;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.versions.ReleaseType;

public class Profile {
    public static final String DEFAULT_JRE_ARGUMENTS_64BIT = "-Xmx1G";
    public static final String DEFAULT_JRE_ARGUMENTS_32BIT = "-Xmx512M";
    public static final Profile$Resolution DEFAULT_RESOLUTION = new Profile$Resolution(854, 480);
    public static final LauncherVisibilityRule DEFAULT_LAUNCHER_VISIBILITY = LauncherVisibilityRule.CLOSE_LAUNCHER;
    public static final Set<ReleaseType> DEFAULT_RELEASE_TYPES = new HashSet<ReleaseType>(Arrays.asList(ReleaseType.RELEASE));
    private String name;
    private File gameDir;
    private String lastVersionId;
    private String javaDir;
    private String javaArgs;
    private Profile$Resolution resolution;
    private Set<ReleaseType> allowedReleaseTypes;
    private String playerUUID;
    private Boolean useHopperCrashService;
    private LauncherVisibilityRule launcherVisibilityOnGameClose;
    private Map<String, String> authentication;

    public Profile() {
    }

    public Profile(Profile profile) {
        this.name = profile.name;
        this.gameDir = profile.gameDir;
        this.playerUUID = profile.playerUUID;
        this.lastVersionId = profile.lastVersionId;
        this.javaDir = profile.javaDir;
        this.javaArgs = profile.javaArgs;
        this.resolution = profile.resolution == null ? null : new Profile$Resolution(profile.resolution);
        this.allowedReleaseTypes = profile.allowedReleaseTypes == null ? null : new HashSet<ReleaseType>(profile.allowedReleaseTypes);
        this.useHopperCrashService = profile.useHopperCrashService;
        this.launcherVisibilityOnGameClose = profile.launcherVisibilityOnGameClose;
    }

    public Profile(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public void setGameDir(File file) {
        this.gameDir = file;
    }

    public void setLastVersionId(String string) {
        this.lastVersionId = string;
    }

    public void setJavaDir(String string) {
        this.javaDir = string;
    }

    public void setJavaArgs(String string) {
        this.javaArgs = string;
    }

    public String getLastVersionId() {
        return this.lastVersionId;
    }

    public String getJavaArgs() {
        return this.javaArgs;
    }

    public String getJavaPath() {
        return this.javaDir;
    }

    public Profile$Resolution getResolution() {
        return this.resolution;
    }

    public void setResolution(Profile$Resolution profile$Resolution) {
        this.resolution = profile$Resolution;
    }

    public String getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(String string) {
        this.playerUUID = string;
    }

    public Set<ReleaseType> getAllowedReleaseTypes() {
        return this.allowedReleaseTypes;
    }

    public void setAllowedReleaseTypes(Set<ReleaseType> set) {
        this.allowedReleaseTypes = set;
    }

    public boolean getUseHopperCrashService() {
        return this.useHopperCrashService == null;
    }

    public void setUseHopperCrashService(boolean bl) {
        this.useHopperCrashService = bl ? null : Boolean.valueOf(false);
    }

    public VersionFilter getVersionFilter() {
        VersionFilter versionFilter = new VersionFilter().setMaxCount(Integer.MAX_VALUE);
        if (this.allowedReleaseTypes == null) {
            versionFilter.onlyForTypes(DEFAULT_RELEASE_TYPES.toArray(new ReleaseType[DEFAULT_RELEASE_TYPES.size()]));
        } else {
            versionFilter.onlyForTypes(this.allowedReleaseTypes.toArray(new ReleaseType[this.allowedReleaseTypes.size()]));
        }
        return versionFilter;
    }

    public LauncherVisibilityRule getLauncherVisibilityOnGameClose() {
        return this.launcherVisibilityOnGameClose;
    }

    public void setLauncherVisibilityOnGameClose(LauncherVisibilityRule launcherVisibilityRule) {
        this.launcherVisibilityOnGameClose = launcherVisibilityRule;
    }

    public Map<String, String> getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Map<String, String> map) {
        this.authentication = map;
    }
}

