/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.process.JavaProcess;

public class ProcessMonitorThread
extends Thread {
    private final JavaProcess process;

    public ProcessMonitorThread(JavaProcess javaProcess) {
        this.process = javaProcess;
    }

    @Override
    public void run() {
        Reader reader = new InputStreamReader(this.process.getRawProcess().getInputStream());
        reader = new BufferedReader(reader);
        Object object = null;
        while (this.process.isRunning()) {
            try {
                while ((object = ((BufferedReader)reader).readLine()) != null) {
                    Launcher.getInstance().println("Client> " + (String)object);
                    this.process.getSysOutLines().add((String)object);
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(ProcessMonitorThread.class.getName()).log(Level.SEVERE, null, iOException);
            }
            finally {
                try {
                    ((BufferedReader)reader).close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(ProcessMonitorThread.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
        }
        object = this.process.getExitRunnable();
        if (object != null) {
            object.onJavaProcessEnded(this.process);
        }
    }
}

