/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import java.lang.reflect.Array;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LimitedCapacityList<T> {
    private final T[] items;
    private final Class<? extends T> clazz;
    private final ReadWriteLock locks = new ReentrantReadWriteLock();
    private int size;
    private int head;

    public LimitedCapacityList(Class<? extends T> clazz, int n2) {
        this.clazz = clazz;
        this.items = (Object[])Array.newInstance(clazz, n2);
    }

    public T add(T t2) {
        this.locks.writeLock().lock();
        this.items[this.head] = t2;
        this.head = (this.head + 1) % this.getMaxSize();
        if (this.size < this.getMaxSize()) {
            ++this.size;
        }
        this.locks.writeLock().unlock();
        return t2;
    }

    public int getSize() {
        this.locks.readLock().lock();
        int n2 = this.size;
        this.locks.readLock().unlock();
        return n2;
    }

    public int getMaxSize() {
        this.locks.readLock().lock();
        int n2 = this.items.length;
        this.locks.readLock().unlock();
        return n2;
    }

    public T[] getItems() {
        Object[] objectArray = (Object[])Array.newInstance(this.clazz, this.size);
        this.locks.readLock().lock();
        for (int i2 = 0; i2 < this.size; ++i2) {
            int n2 = (this.head - this.size + i2) % this.getMaxSize();
            if (n2 < 0) {
                n2 += this.getMaxSize();
            }
            objectArray[i2] = this.items[n2];
        }
        this.locks.readLock().unlock();
        return objectArray;
    }
}

