/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.process.JavaProcess;

public class JavaProcessLauncher {
    private final String jvmPath;
    private final List<String> commands;
    private File directory;

    public JavaProcessLauncher(String string, String ... stringArray) {
        if (string == null) {
            string = OperatingSystem.getCurrentPlatform().getJavaDir();
        }
        this.jvmPath = string;
        this.commands = new ArrayList<String>(stringArray.length);
        this.addCommands(stringArray);
    }

    public JavaProcess start() {
        List<String> list = this.getFullCommands();
        return new JavaProcess(list, new ProcessBuilder(list).directory(this.directory).redirectErrorStream(true).start());
    }

    public List<String> getFullCommands() {
        ArrayList<String> arrayList = new ArrayList<String>(this.commands);
        arrayList.add(0, this.getJavaPath());
        return arrayList;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void addCommands(String ... stringArray) {
        this.commands.addAll(Arrays.asList(stringArray));
    }

    public void addSplitCommands(String string) {
        this.addCommands(string.split(" "));
    }

    public JavaProcessLauncher directory(File file) {
        this.directory = file;
        return this;
    }

    public File getDirectory() {
        return this.directory;
    }

    protected String getJavaPath() {
        return this.jvmPath;
    }

    public final String toString() {
        return "JavaProcessLauncher[commands=" + this.commands + ", java=" + this.jvmPath + "]";
    }
}

