/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import java.util.List;
import net.minecraft.launcher.process.JavaProcessRunnable;
import net.minecraft.launcher.process.LimitedCapacityList;
import net.minecraft.launcher.process.ProcessMonitorThread;

public class JavaProcess {
    private static final int MAX_SYSOUT_LINES = 5;
    private final List<String> commands;
    private final Process process;
    private final LimitedCapacityList<String> sysOutLines = new LimitedCapacityList<String>(String.class, 5);
    private JavaProcessRunnable onExit;
    private ProcessMonitorThread monitor = new ProcessMonitorThread(this);

    public JavaProcess(List<String> list, Process process) {
        this.commands = list;
        this.process = process;
        this.monitor.start();
    }

    public Process getRawProcess() {
        return this.process;
    }

    public List<String> getStartupCommands() {
        return this.commands;
    }

    public String getStartupCommand() {
        return this.process.toString();
    }

    public LimitedCapacityList<String> getSysOutLines() {
        return this.sysOutLines;
    }

    public boolean isRunning() {
        try {
            this.process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        return false;
    }

    public void setExitRunnable(JavaProcessRunnable javaProcessRunnable) {
        this.onExit = javaProcessRunnable;
    }

    public void safeSetExitRunnable(JavaProcessRunnable javaProcessRunnable) {
        this.setExitRunnable(javaProcessRunnable);
        if (!this.isRunning() && javaProcessRunnable != null) {
            javaProcessRunnable.onJavaProcessEnded(this);
        }
    }

    public JavaProcessRunnable getExitRunnable() {
        return this.onExit;
    }

    public int getExitCode() {
        try {
            return this.process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            IllegalThreadStateException illegalThreadStateException2 = illegalThreadStateException;
            illegalThreadStateException.fillInStackTrace();
            throw illegalThreadStateException2;
        }
    }

    public final String toString() {
        return "JavaProcess[commands=" + this.commands + ", isRunning=" + this.isRunning() + "]";
    }

    public void stop() {
        this.process.destroy();
    }
}

