/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.authentication.yggdrasil;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.hopper.Util;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.BaseAuthenticationService;
import net.minecraft.launcher.authentication.GameProfile;
import net.minecraft.launcher.authentication.exceptions.AuthenticationException;
import net.minecraft.launcher.authentication.exceptions.InvalidCredentialsException;
import net.minecraft.launcher.authentication.exceptions.UserMigratedException;
import net.minecraft.launcher.authentication.yggdrasil.Agent;
import net.minecraft.launcher.authentication.yggdrasil.AuthenticationRequest;
import net.minecraft.launcher.authentication.yggdrasil.AuthenticationResponse;
import net.minecraft.launcher.authentication.yggdrasil.RefreshRequest;
import net.minecraft.launcher.authentication.yggdrasil.RefreshResponse;
import net.minecraft.launcher.authentication.yggdrasil.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class YggdrasilAuthenticationService
extends BaseAuthenticationService {
    private static final String BASE_URL = "https://authserver.mojang.com/";
    private static final URL ROUTE_AUTHENTICATE = Util.constantURL("https://authserver.mojang.com/authenticate");
    private static final URL ROUTE_REFRESH = Util.constantURL("https://authserver.mojang.com/refresh");
    private static final URL ROUTE_VALIDATE = Util.constantURL("https://authserver.mojang.com/validate");
    private static final URL ROUTE_INVALIDATE = Util.constantURL("https://authserver.mojang.com/invalidate");
    private static final URL ROUTE_SIGNOUT = Util.constantURL("https://authserver.mojang.com/signout");
    private static final String STORAGE_KEY_ACCESS_TOKEN = "accessToken";
    private final Gson gson = new Gson();
    private final Agent agent = Agent.MINECRAFT;
    private GameProfile[] profiles;
    private String accessToken;
    private boolean isOnline;

    @Override
    public boolean canLogIn() {
        return !this.canPlayOnline() && StringUtils.isNotBlank(this.getUsername()) && (StringUtils.isNotBlank(this.getPassword()) || StringUtils.isNotBlank(this.getAccessToken()));
    }

    @Override
    public void logIn() {
        if (StringUtils.isBlank(this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isNotBlank(this.getAccessToken())) {
            this.logInWithToken();
            return;
        }
        if (StringUtils.isNotBlank(this.getPassword())) {
            this.logInWithPassword();
            return;
        }
        throw new InvalidCredentialsException("Invalid password");
    }

    protected void logInWithPassword() {
        if (StringUtils.isBlank(this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isBlank(this.getPassword())) {
            throw new InvalidCredentialsException("Invalid password");
        }
        Launcher.getInstance().println("Logging in with username & password");
        Object object = new AuthenticationRequest(this, this.getPassword());
        object = this.makeRequest(ROUTE_AUTHENTICATE, object, AuthenticationResponse.class);
        if (!((AuthenticationResponse)object).getClientToken().equals(this.getClientToken())) {
            throw new AuthenticationException("Server requested we change our client token. Don't know how to handle this!");
        }
        this.accessToken = ((AuthenticationResponse)object).getAccessToken();
        this.profiles = ((AuthenticationResponse)object).getAvailableProfiles();
        this.setSelectedProfile(((AuthenticationResponse)object).getSelectedProfile());
        this.fireAuthenticationChangedEvent();
    }

    protected void logInWithToken() {
        if (StringUtils.isBlank(this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isBlank(this.getAccessToken())) {
            throw new InvalidCredentialsException("Invalid access token");
        }
        Launcher.getInstance().println("Logging in with access token");
        Object object = new RefreshRequest(this);
        object = this.makeRequest(ROUTE_REFRESH, object, RefreshResponse.class);
        if (!((RefreshResponse)object).getClientToken().equals(this.getClientToken())) {
            throw new AuthenticationException("Server requested we change our client token. Don't know how to handle this!");
        }
        this.accessToken = ((RefreshResponse)object).getAccessToken();
        this.profiles = ((RefreshResponse)object).getAvailableProfiles();
        this.setSelectedProfile(((RefreshResponse)object).getSelectedProfile());
        this.fireAuthenticationChangedEvent();
    }

    protected <T extends Response> T makeRequest(URL object, Object object2, Class<T> clazz) {
        try {
            object = Util.performPost((URL)object, this.gson.toJson(object2), Launcher.getInstance().getProxy(), "application/json", true);
            System.out.println((String)object);
            object = (Response)this.gson.fromJson((String)object, clazz);
            if (object == null) {
                return null;
            }
            if (StringUtils.isNotBlank(((Response)object).getError())) {
                if ("UserMigratedException".equals(((Response)object).getCause())) {
                    throw new UserMigratedException(((Response)object).getErrorMessage());
                }
                if (((Response)object).getError().equals("ForbiddenOperationException")) {
                    throw new InvalidCredentialsException(((Response)object).getErrorMessage());
                }
                throw new AuthenticationException(((Response)object).getErrorMessage());
            }
            this.isOnline = true;
            return (T)object;
        }
        catch (IOException iOException) {
            throw new AuthenticationException("Cannot contact authentication server", iOException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new AuthenticationException("Cannot contact authentication server", illegalStateException);
        }
        catch (JsonParseException jsonParseException) {
            throw new AuthenticationException("Cannot contact authentication server", jsonParseException);
        }
    }

    @Override
    public void logOut() {
        super.logOut();
        this.accessToken = null;
        this.profiles = null;
        this.isOnline = false;
    }

    @Override
    public GameProfile[] getAvailableProfiles() {
        return this.profiles;
    }

    @Override
    public boolean isLoggedIn() {
        return StringUtils.isNotBlank(this.accessToken);
    }

    @Override
    public boolean canPlayOnline() {
        return this.isLoggedIn() && this.getSelectedProfile() != null && this.isOnline;
    }

    @Override
    public void selectGameProfile(GameProfile object) {
        if (!this.isLoggedIn()) {
            throw new AuthenticationException("Cannot change game profile whilst not logged in");
        }
        if (this.getSelectedProfile() != null) {
            throw new AuthenticationException("Cannot change game profile. You must log out and back in.");
        }
        if (object == null || !ArrayUtils.contains(this.profiles, object)) {
            throw new IllegalArgumentException("Invalid profile '" + object + "'");
        }
        object = new RefreshRequest(this, (GameProfile)object);
        if (!((RefreshResponse)(object = this.makeRequest(ROUTE_REFRESH, object, RefreshResponse.class))).getClientToken().equals(this.getClientToken())) {
            throw new AuthenticationException("Server requested we change our client token. Don't know how to handle this!");
        }
        this.accessToken = ((RefreshResponse)object).getAccessToken();
        this.setSelectedProfile(((RefreshResponse)object).getSelectedProfile());
        this.fireAuthenticationChangedEvent();
    }

    @Override
    public void loadFromStorage(Map<String, String> map) {
        super.loadFromStorage(map);
        this.accessToken = map.get(STORAGE_KEY_ACCESS_TOKEN);
    }

    @Override
    public Map<String, String> saveForStorage() {
        Map<String, String> map = super.saveForStorage();
        if (!this.shouldRememberMe()) {
            return map;
        }
        if (StringUtils.isNotBlank(this.getAccessToken())) {
            map.put(STORAGE_KEY_ACCESS_TOKEN, this.getAccessToken());
        }
        return map;
    }

    @Override
    public String getSessionToken() {
        if (this.isLoggedIn() && this.getSelectedProfile() != null && this.canPlayOnline()) {
            return String.format("token:%s:%s", this.getAccessToken(), this.getSelectedProfile().getId());
        }
        return null;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getClientToken() {
        return Launcher.getInstance().getClientToken().toString();
    }

    public Agent getAgent() {
        return this.agent;
    }

    @Override
    public final String toString() {
        return "YggdrasilAuthenticationService{agent=" + this.agent + ", profiles=" + Arrays.toString(this.profiles) + ", selectedProfile=" + this.getSelectedProfile() + ", sessionToken='" + this.getSessionToken() + '\'' + ", username='" + this.getUsername() + '\'' + ", isLoggedIn=" + this.isLoggedIn() + ", canPlayOnline=" + this.canPlayOnline() + ", accessToken='" + this.accessToken + '\'' + ", clientToken='" + this.getClientToken() + '\'' + '}';
    }
}

