/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.authentication;

import java.io.File;
import java.util.Map;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.authentication.GameProfile;
import net.minecraft.launcher.authentication.LegacyAuthenticationService;
import net.minecraft.launcher.authentication.exceptions.AuthenticationException;
import net.minecraft.launcher.authentication.yggdrasil.YggdrasilAuthenticationService;
import net.minecraft.launcher.events.AuthenticationChangedListener;

public class LoadTestingAuthenticationService
implements AuthenticationService {
    private final AuthenticationService primary = new LegacyAuthenticationService();
    private final AuthenticationService secondary = new YggdrasilAuthenticationService();

    @Override
    public void logIn() {
        this.primary.logIn();
        try {
            this.secondary.logIn();
            return;
        }
        catch (AuthenticationException authenticationException) {
            Launcher.getInstance().println("Couldn't load-test new authentication service (method: logIn)", authenticationException);
            return;
        }
    }

    @Override
    public boolean canLogIn() {
        return this.primary.canLogIn();
    }

    @Override
    public void logOut() {
        this.primary.logOut();
        this.secondary.logOut();
    }

    @Override
    public boolean isLoggedIn() {
        return this.primary.isLoggedIn();
    }

    @Override
    public boolean canPlayOnline() {
        return this.primary.canPlayOnline();
    }

    @Override
    public GameProfile[] getAvailableProfiles() {
        return this.primary.getAvailableProfiles();
    }

    @Override
    public GameProfile getSelectedProfile() {
        return this.primary.getSelectedProfile();
    }

    @Override
    public void selectGameProfile(GameProfile gameProfile) {
        this.primary.selectGameProfile(gameProfile);
        try {
            this.secondary.selectGameProfile(gameProfile);
            return;
        }
        catch (AuthenticationException authenticationException) {
            Launcher.getInstance().println("Couldn't load-test new authentication service (method: selectGameProfile)", authenticationException);
            return;
        }
    }

    @Override
    public void loadFromStorage(Map<String, String> map) {
        this.primary.loadFromStorage(map);
        this.secondary.loadFromStorage(map);
    }

    @Override
    public Map<String, String> saveForStorage() {
        return this.primary.saveForStorage();
    }

    @Override
    public String getSessionToken() {
        return this.primary.getSessionToken();
    }

    @Override
    public String getUsername() {
        return this.primary.getUsername();
    }

    @Override
    public void setUsername(String string) {
        this.primary.setUsername(string);
        this.secondary.setUsername(string);
    }

    @Override
    public void setPassword(String string) {
        this.primary.setPassword(string);
        this.secondary.setPassword(string);
    }

    @Override
    public void addAuthenticationChangedListener(AuthenticationChangedListener authenticationChangedListener) {
        this.primary.addAuthenticationChangedListener(authenticationChangedListener);
    }

    @Override
    public void removeAuthenticationChangedListener(AuthenticationChangedListener authenticationChangedListener) {
        this.primary.removeAuthenticationChangedListener(authenticationChangedListener);
    }

    @Override
    public String guessPasswordFromSillyOldFormat(File file) {
        return this.primary.guessPasswordFromSillyOldFormat(file);
    }

    @Override
    public void setRememberMe(boolean bl) {
        this.primary.setRememberMe(bl);
        this.secondary.setRememberMe(bl);
    }

    @Override
    public boolean shouldRememberMe() {
        return this.primary.shouldRememberMe();
    }
}

