/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.authentication;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import net.minecraft.hopper.Util;
import net.minecraft.launcher.Http;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.BaseAuthenticationService;
import net.minecraft.launcher.authentication.GameProfile;
import net.minecraft.launcher.authentication.exceptions.AuthenticationException;
import net.minecraft.launcher.authentication.exceptions.InvalidCredentialsException;
import org.apache.commons.lang3.StringUtils;

public class LegacyAuthenticationService
extends BaseAuthenticationService {
    private static final URL AUTHENTICATION_URL = Util.constantURL("https://login.minecraft.net");
    private static final int AUTHENTICATION_VERSION = 14;
    private static final int RESPONSE_PART_PROFILE_NAME = 2;
    private static final int RESPONSE_PART_SESSION_TOKEN = 3;
    private static final int RESPONSE_PART_PROFILE_ID = 4;
    private String sessionToken;

    @Override
    public void logIn() {
        if (StringUtils.isBlank(this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isBlank(this.getPassword())) {
            throw new InvalidCredentialsException("Invalid password");
        }
        Object object = new HashMap<String, Object>();
        object.put("user", this.getUsername());
        object.put("password", this.getPassword());
        object.put("version", 14);
        try {
            object = Http.performPost(AUTHENTICATION_URL, object, Launcher.getInstance().getProxy()).trim();
        }
        catch (IOException iOException) {
            throw new AuthenticationException("Authentication server is not responding", iOException);
        }
        Object object2 = ((String)object).split(":");
        if (((String[])object2).length == 5) {
            String string = object2[4];
            String string2 = object2[2];
            object2 = object2[3];
            if (StringUtils.isBlank(string) || StringUtils.isBlank(string2) || StringUtils.isBlank((CharSequence)object2)) {
                throw new AuthenticationException("Unknown response from authentication server: " + (String)object);
            }
            this.setSelectedProfile(new GameProfile(string, string2));
            this.sessionToken = object2;
            this.fireAuthenticationChangedEvent();
            return;
        }
        throw new InvalidCredentialsException((String)object);
    }

    @Override
    public void logOut() {
        super.logOut();
        this.sessionToken = null;
        this.fireAuthenticationChangedEvent();
    }

    @Override
    public GameProfile[] getAvailableProfiles() {
        if (this.getSelectedProfile() != null) {
            return new GameProfile[]{this.getSelectedProfile()};
        }
        return new GameProfile[0];
    }

    @Override
    public void selectGameProfile(GameProfile gameProfile) {
        throw new UnsupportedOperationException("Game profiles cannot be changed in the legacy authentication service");
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }
}

