/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.authentication;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.authentication.BaseAuthenticationService$1;
import net.minecraft.launcher.authentication.GameProfile;
import net.minecraft.launcher.events.AuthenticationChangedListener;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseAuthenticationService
implements AuthenticationService {
    private static final String LEGACY_LASTLOGIN_PASSWORD = "passwordfile";
    private static final int LEGACY_LASTLOGIN_SEED = 43287234;
    private final List<AuthenticationChangedListener> listeners = new ArrayList<AuthenticationChangedListener>();
    private String username;
    private String password;
    private GameProfile selectedProfile;
    private boolean shouldRememberMe = true;

    @Override
    public boolean canLogIn() {
        return !this.canPlayOnline() && StringUtils.isNotBlank(this.getUsername()) && StringUtils.isNotBlank(this.getPassword());
    }

    @Override
    public void logOut() {
        this.password = null;
        this.setSelectedProfile(null);
    }

    @Override
    public boolean isLoggedIn() {
        return this.getSelectedProfile() != null;
    }

    @Override
    public boolean canPlayOnline() {
        return this.isLoggedIn() && this.getSelectedProfile() != null && this.getSessionToken() != null;
    }

    @Override
    public void addAuthenticationChangedListener(AuthenticationChangedListener authenticationChangedListener) {
        this.listeners.add(authenticationChangedListener);
    }

    @Override
    public void removeAuthenticationChangedListener(AuthenticationChangedListener authenticationChangedListener) {
        this.listeners.remove(authenticationChangedListener);
    }

    protected void fireAuthenticationChangedEvent() {
        ArrayList<AuthenticationChangedListener> arrayList = new ArrayList<AuthenticationChangedListener>(this.listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            AuthenticationChangedListener authenticationChangedListener = (AuthenticationChangedListener)iterator.next();
            if (authenticationChangedListener.shouldReceiveEventsInUIThread()) continue;
            authenticationChangedListener.onAuthenticationChanged(this);
            iterator.remove();
        }
        if (!arrayList.isEmpty()) {
            SwingUtilities.invokeLater(new BaseAuthenticationService$1(this, arrayList));
        }
    }

    @Override
    public void setUsername(String string) {
        if (this.isLoggedIn() && this.canPlayOnline()) {
            throw new IllegalStateException("Cannot change username whilst logged in & online");
        }
        this.username = string;
    }

    @Override
    public void setPassword(String string) {
        if (this.isLoggedIn() && this.canPlayOnline() && StringUtils.isNotBlank(string)) {
            throw new IllegalStateException("Cannot set password whilst logged in & online");
        }
        this.password = string;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    protected String getPassword() {
        return this.password;
    }

    @Override
    public void loadFromStorage(Map<String, String> map) {
        this.logOut();
        if (map.containsKey("rememberMe")) {
            this.setRememberMe(Boolean.getBoolean(map.get("rememberMe")));
        }
        this.setUsername(map.get("username"));
        if (map.containsKey("displayName") && map.containsKey("uuid")) {
            this.setSelectedProfile(new GameProfile(map.get("uuid"), map.get("displayName")));
        }
    }

    @Override
    public Map<String, String> saveForStorage() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!this.shouldRememberMe()) {
            hashMap.put("rememberMe", Boolean.toString(false));
            return hashMap;
        }
        if (this.getUsername() != null) {
            hashMap.put("username", this.getUsername());
        }
        if (this.getSelectedProfile() != null) {
            hashMap.put("displayName", this.getSelectedProfile().getName());
            hashMap.put("uuid", this.getSelectedProfile().getId());
        }
        return hashMap;
    }

    @Override
    public boolean shouldRememberMe() {
        return this.shouldRememberMe;
    }

    @Override
    public void setRememberMe(boolean bl) {
        this.shouldRememberMe = bl;
    }

    protected void setSelectedProfile(GameProfile gameProfile) {
        this.selectedProfile = gameProfile;
    }

    @Override
    public GameProfile getSelectedProfile() {
        return this.selectedProfile;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("{");
        if (this.isLoggedIn()) {
            stringBuilder.append("Logged in as ");
            stringBuilder.append(this.getUsername());
            if (this.getSelectedProfile() != null) {
                stringBuilder.append(" / ");
                stringBuilder.append(this.getSelectedProfile());
                stringBuilder.append(" - ");
                if (this.canPlayOnline()) {
                    stringBuilder.append("Online with session token '");
                    stringBuilder.append(this.getSessionToken());
                    stringBuilder.append("'");
                } else {
                    stringBuilder.append("Offline");
                }
            }
        } else {
            stringBuilder.append("Not logged in");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String guessPasswordFromSillyOldFormat(File stringArray) {
        if ((stringArray = BaseAuthenticationService.getStoredDetails((File)stringArray)) != null && stringArray[0].equals(this.getUsername())) {
            return stringArray[1];
        }
        return null;
    }

    public static String[] getStoredDetails(File object) {
        if (!((File)object).isFile()) {
            return null;
        }
        try {
            Object object2 = BaseAuthenticationService.getCipher(2, LEGACY_LASTLOGIN_PASSWORD);
            object = object2 != null ? new DataInputStream(new CipherInputStream(new FileInputStream((File)object), (Cipher)object2)) : new DataInputStream(new FileInputStream((File)object));
            object2 = ((DataInputStream)object).readUTF();
            String string = ((DataInputStream)object).readUTF();
            ((FilterInputStream)object).close();
            return new String[]{object2, string};
        }
        catch (Exception exception) {
            Launcher.getInstance().println("Couldn't load old lastlogin file", exception);
            return null;
        }
    }

    private static Cipher getCipher(int n2, String object) {
        Object object2 = new Random(43287234L);
        Object object3 = new byte[8];
        ((Random)object2).nextBytes((byte[])object3);
        object2 = new PBEParameterSpec((byte[])object3, 5);
        object = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(new PBEKeySpec(((String)object).toCharArray()));
        Cipher cipher = Cipher.getInstance("PBEWithMD5AndDES");
        object3 = cipher;
        cipher.init(n2, (Key)object, (AlgorithmParameterSpec)object2);
        return object3;
    }
}

