/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.authentication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.authentication.GameProfile;

public class AuthenticationDatabase {
    public static final String DEMO_UUID_PREFIX = "demo-";
    private final Map<String, AuthenticationService> authById;

    public AuthenticationDatabase() {
        this(new HashMap<String, AuthenticationService>());
    }

    public AuthenticationDatabase(Map<String, AuthenticationService> map) {
        this.authById = map;
    }

    public AuthenticationService getByName(String string) {
        if (string == null) {
            return null;
        }
        for (Map.Entry<String, AuthenticationService> entry : this.authById.entrySet()) {
            GameProfile gameProfile = entry.getValue().getSelectedProfile();
            if (gameProfile != null && gameProfile.getName().equals(string)) {
                return entry.getValue();
            }
            if (gameProfile != null || !AuthenticationDatabase.getUserFromDemoUUID(entry.getKey()).equals(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    public AuthenticationService getByUUID(String string) {
        return this.authById.get(string);
    }

    public Collection<String> getKnownNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, AuthenticationService> entry : this.authById.entrySet()) {
            GameProfile gameProfile = entry.getValue().getSelectedProfile();
            if (gameProfile != null) {
                arrayList.add(gameProfile.getName());
                continue;
            }
            arrayList.add(AuthenticationDatabase.getUserFromDemoUUID(entry.getKey()));
        }
        return arrayList;
    }

    public void register(String string, AuthenticationService authenticationService) {
        this.authById.put(string, authenticationService);
    }

    public Set<String> getknownUUIDs() {
        return this.authById.keySet();
    }

    public void removeUUID(String string) {
        this.authById.remove(string);
    }

    public static String getUserFromDemoUUID(String string) {
        if (string.startsWith(DEMO_UUID_PREFIX) && string.length() > DEMO_UUID_PREFIX.length()) {
            return "Demo User " + string.substring(DEMO_UUID_PREFIX.length());
        }
        return "Demo User";
    }

    static /* synthetic */ Map a(AuthenticationDatabase authenticationDatabase) {
        return authenticationDatabase.authById;
    }
}

