/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import java.io.File;
import java.net.URI;
import net.minecraft.launcher.Launcher;

public enum OperatingSystem {
    LINUX("linux", "linux", "unix"),
    WINDOWS("windows", "win"),
    OSX("osx", "mac"),
    UNKNOWN("unknown", new String[0]);

    private final String name;
    private final String[] aliases;

    private OperatingSystem(String string2, String ... stringArray) {
        this.name = string2;
        this.aliases = stringArray == null ? new String[]{} : stringArray;
    }

    public final String getName() {
        return this.name;
    }

    public final String[] getAliases() {
        return this.aliases;
    }

    public final boolean isSupported() {
        return this != UNKNOWN;
    }

    public final String getJavaDir() {
        String string = System.getProperty("file.separator");
        string = System.getProperty("java.home") + string + "bin" + string;
        if (OperatingSystem.getCurrentPlatform() == WINDOWS && new File(string + "javaw.exe").isFile()) {
            return string + "javaw.exe";
        }
        return string + "java";
    }

    public static OperatingSystem getCurrentPlatform() {
        String string = System.getProperty("os.name").toLowerCase();
        for (OperatingSystem operatingSystem : OperatingSystem.values()) {
            for (String string2 : operatingSystem.getAliases()) {
                if (!string.contains(string2)) continue;
                return operatingSystem;
            }
        }
        return UNKNOWN;
    }

    public static void openLink(URI uRI) {
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Object object = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            clazz.getMethod("browse", URI.class).invoke(object, uRI);
            return;
        }
        catch (Throwable throwable) {
            Launcher.getInstance().println("Failed to open link " + uRI.toString(), throwable);
            return;
        }
    }
}

