/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.minecraft.launcher.GameLauncher;
import net.minecraft.launcher.Launcher$1;
import net.minecraft.launcher.Launcher$2;
import net.minecraft.launcher.Launcher$3;
import net.minecraft.launcher.Launcher$4;
import net.minecraft.launcher.LauncherConstants;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.authentication.exceptions.AuthenticationException;
import net.minecraft.launcher.authentication.exceptions.InvalidCredentialsException;
import net.minecraft.launcher.authentication.yggdrasil.YggdrasilAuthenticationService;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.profile.ProfileManager;
import net.minecraft.launcher.ui.LauncherPanel;
import net.minecraft.launcher.ui.popups.login.LogInPopup;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.updater.VersionManager;
import net.minecraft.launcher.updater.download.DownloadJob;

public class Launcher {
    private static Launcher instance;
    private static final List<String> delayedSysout;
    private final VersionManager versionManager;
    private final JFrame frame;
    private final LauncherPanel launcherPanel;
    private final GameLauncher gameLauncher;
    private final File workingDirectory;
    private final Proxy proxy;
    private final PasswordAuthentication proxyAuth;
    private final String[] additionalArgs;
    private final Integer bootstrapVersion;
    private final ProfileManager profileManager;
    private UUID clientToken = UUID.randomUUID();

    public Launcher(JFrame jFrame, File file, Proxy proxy, PasswordAuthentication passwordAuthentication, String[] stringArray) {
        this(jFrame, file, proxy, passwordAuthentication, stringArray, 0);
    }

    /*
     * WARNING - void declaration
     */
    public Launcher(JFrame object, File object22, Proxy proxy, PasswordAuthentication passwordAuthentication, String[] stringArray, Integer n2) {
        void var5_7;
        void var4_6;
        void var3_5;
        void var6_8;
        this.bootstrapVersion = var6_8;
        instance = this;
        Launcher.setLookAndFeel();
        this.proxy = var3_5;
        this.proxyAuth = var4_6;
        this.additionalArgs = var5_7;
        this.workingDirectory = object22;
        this.frame = object;
        this.gameLauncher = new GameLauncher(this);
        this.profileManager = new ProfileManager(this);
        this.versionManager = new VersionManager(new LocalVersionList((File)object22), new RemoteVersionList((Proxy)var3_5));
        this.launcherPanel = new LauncherPanel(this);
        for (String string : delayedSysout) {
            this.launcherPanel.getTabPanel().getConsole().print(string + "\n");
        }
        if (var6_8.intValue() < 4) {
            this.showOutdatedNotice();
            return;
        }
        this.println("Launcher 1.2.1 (through bootstrap " + var6_8 + ") started on " + OperatingSystem.getCurrentPlatform().getName() + "...");
        this.println("Current time is " + DateFormat.getDateTimeInstance(2, 2, Locale.US).format(new Date()));
        if (!OperatingSystem.getCurrentPlatform().isSupported()) {
            this.println("This operating system is unknown or unsupported, we cannot guarantee that the game will launch.");
        }
        this.println("System.getProperty('os.name') == '" + System.getProperty("os.name") + "'");
        this.println("System.getProperty('os.version') == '" + System.getProperty("os.version") + "'");
        this.println("System.getProperty('os.arch') == '" + System.getProperty("os.arch") + "'");
        this.println("System.getProperty('java.version') == '" + System.getProperty("java.version") + "'");
        this.println("System.getProperty('java.vendor') == '" + System.getProperty("java.vendor") + "'");
        this.println("System.getProperty('sun.arch.data.model') == '" + System.getProperty("sun.arch.data.model") + "'");
    }

    private void showOutdatedNotice() {
        String string = "Sorry, but your launcher is outdated! Please redownload it at https://mojang.com/2013/06/minecraft-1-6-pre-release/";
        this.frame.getContentPane().removeAll();
        int n2 = JOptionPane.showOptionDialog(this.frame, string, "Outdated launcher", 0, 0, null, LauncherConstants.BOOTSTRAP_OUT_OF_DATE_BUTTONS, LauncherConstants.BOOTSTRAP_OUT_OF_DATE_BUTTONS[0]);
        if (n2 == 0) {
            try {
                OperatingSystem.openLink(new URI("https://mojang.com/2013/06/minecraft-1-6-pre-release/"));
            }
            catch (URISyntaxException uRISyntaxException) {
                this.println("Couldn't open bootstrap download link. Please visit https://mojang.com/2013/06/minecraft-1-6-pre-release/ manually.", uRISyntaxException);
            }
        }
        this.closeLauncher();
    }

    private static void setLookAndFeel() {
        JFrame jFrame = new JFrame();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            try {
                Launcher.getInstance().println("Your java failed to provide normal look and feel, trying the old fallback now");
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Throwable throwable2) {
                Launcher.getInstance().println("Unexpected exception setting look and feel");
                throwable2.printStackTrace();
            }
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("test"));
        jFrame.add(jPanel);
        try {
            jFrame.pack();
        }
        catch (Throwable throwable) {
            Launcher.getInstance().println("Custom (broken) theme detected, falling back onto x-platform theme");
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Throwable throwable3) {
                Launcher.getInstance().println("Unexpected exception setting look and feel", throwable3);
            }
        }
        jFrame.dispose();
    }

    private void downloadResources() {
        DownloadJob downloadJob = new DownloadJob("Resources", true, this.gameLauncher);
        this.gameLauncher.addJob(downloadJob);
        this.versionManager.getExecutorService().submit(new Launcher$1(this, downloadJob));
    }

    public void refreshVersionsAndProfiles() {
        this.versionManager.getExecutorService().submit(new Launcher$2(this));
    }

    public void ensureLoggedIn() {
        Object object = this.profileManager.getSelectedProfile();
        object = this.profileManager.getAuthDatabase().getByUUID(((Profile)object).getPlayerUUID());
        if (object == null) {
            this.showLoginPrompt();
            return;
        }
        if (!object.isLoggedIn()) {
            if (object.canLogIn()) {
                try {
                    object.logIn();
                    try {
                        this.profileManager.saveProfiles();
                    }
                    catch (IOException iOException) {
                        this.println("Couldn't save profiles after refreshing auth!", iOException);
                    }
                    this.profileManager.fireRefreshEvent();
                    return;
                }
                catch (AuthenticationException authenticationException) {
                    this.println(authenticationException);
                    this.showLoginPrompt();
                    return;
                }
            }
            this.showLoginPrompt();
            return;
        }
        if (!object.canPlayOnline()) {
            try {
                this.println("Refreshing auth...");
                object.logIn();
                try {
                    this.profileManager.saveProfiles();
                }
                catch (IOException iOException) {
                    this.println("Couldn't save profiles after refreshing auth!", iOException);
                }
                this.profileManager.fireRefreshEvent();
                return;
            }
            catch (InvalidCredentialsException invalidCredentialsException) {
                this.println(invalidCredentialsException);
                this.showLoginPrompt();
                return;
            }
            catch (AuthenticationException authenticationException) {
                this.println(authenticationException);
            }
        }
    }

    public void showLoginPrompt() {
        try {
            this.profileManager.saveProfiles();
        }
        catch (IOException iOException) {
            this.println("Couldn't save profiles before logging in!", iOException);
        }
        for (Profile profile : this.profileManager.getProfiles().values()) {
            Map<String, String> map = profile.getAuthentication();
            if (map == null) continue;
            YggdrasilAuthenticationService yggdrasilAuthenticationService = new YggdrasilAuthenticationService();
            yggdrasilAuthenticationService.loadFromStorage(map);
            if (yggdrasilAuthenticationService.isLoggedIn()) {
                Map<String, String> map2 = map = yggdrasilAuthenticationService.getSelectedProfile() == null ? "demo-" + yggdrasilAuthenticationService.getUsername() : yggdrasilAuthenticationService.getSelectedProfile().getId();
                if (this.profileManager.getAuthDatabase().getByUUID((String)((Object)map)) == null) {
                    this.profileManager.getAuthDatabase().register((String)((Object)map), yggdrasilAuthenticationService);
                }
            }
            profile.setAuthentication(null);
        }
        Profile profile = this.profileManager.getSelectedProfile();
        LogInPopup.showLoginPrompt(this, new Launcher$3(this, profile));
    }

    public void closeLauncher() {
        this.frame.dispatchEvent(new WindowEvent(this.frame, 201));
    }

    protected void initializeFrame() {
        this.frame.getContentPane().removeAll();
        this.frame.setTitle("Minecraft Launcher 1.2.1");
        this.frame.setPreferredSize(new Dimension(900, 580));
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new Launcher$4(this));
        try {
            InputStream inputStream = Launcher.class.getResourceAsStream("/favicon.png");
            if (inputStream != null) {
                this.frame.setIconImage(ImageIO.read(inputStream));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.frame.add(this.launcherPanel);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public LauncherPanel getLauncherPanel() {
        return this.launcherPanel;
    }

    public GameLauncher getGameLauncher() {
        return this.gameLauncher;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public PasswordAuthentication getProxyAuth() {
        return this.proxyAuth;
    }

    public String[] getAdditionalArgs() {
        return this.additionalArgs;
    }

    public void println(String string) {
        System.out.println(string);
        if (this.launcherPanel == null) {
            delayedSysout.add(string);
            return;
        }
        this.launcherPanel.getTabPanel().getConsole().print(string + "\n");
    }

    public void println(String string, Throwable throwable) {
        this.println(string);
        this.println(throwable);
    }

    public void println(Throwable object) {
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        try {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            ((Throwable)object).printStackTrace(printWriter);
            object = stringWriter.toString();
        }
        catch (Throwable throwable) {
            try {
                if (stringWriter != null) {
                    stringWriter.close();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stringWriter.close();
            printWriter.close();
        }
        catch (IOException iOException) {}
        this.println((String)object);
    }

    public int getBootstrapVersion() {
        return this.bootstrapVersion;
    }

    public static Launcher getInstance() {
        return instance;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public UUID getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(UUID uUID) {
        this.clientToken = uUID;
    }

    static /* synthetic */ VersionManager a(Launcher launcher) {
        return launcher.versionManager;
    }

    static /* synthetic */ ProfileManager b(Launcher launcher) {
        return launcher.profileManager;
    }

    static /* synthetic */ LauncherPanel c(Launcher launcher) {
        return launcher.launcherPanel;
    }

    static /* synthetic */ JFrame d(Launcher launcher) {
        return launcher.frame;
    }

    static {
        delayedSysout = new ArrayList<String>();
    }
}

