/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import net.minecraft.hopper.Util;
import net.minecraft.launcher.Launcher;
import org.apache.commons.io.IOUtils;

public class Http {
    private Http() {
    }

    public static String buildQuery(Map<String, Object> object) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : object.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            try {
                stringBuilder.append(URLEncoder.encode((String)entry.getKey(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Launcher.getInstance().println("Unexpected exception building query", unsupportedEncodingException);
            }
            if (entry.getValue() == null) continue;
            stringBuilder.append('=');
            try {
                stringBuilder.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Launcher.getInstance().println("Unexpected exception building query", unsupportedEncodingException);
            }
        }
        return stringBuilder.toString();
    }

    public static String performPost(URL uRL, Map<String, Object> map, Proxy proxy) {
        return Util.performPost(uRL, Http.buildQuery(map), proxy, "application/x-www-form-urlencoded", false);
    }

    public static String performGet(URL object, Proxy object2) {
        object = (HttpURLConnection)((URL)object).openConnection((Proxy)object2);
        ((URLConnection)object).setConnectTimeout(15000);
        ((URLConnection)object).setReadTimeout(60000);
        ((HttpURLConnection)object).setRequestMethod("GET");
        object = ((URLConnection)object).getInputStream();
        try {
            object2 = IOUtils.toString((InputStream)object);
            return object2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)object);
        }
    }

    public static URL concatenateURL(URL uRL, String string) {
        if (uRL.getQuery() != null && uRL.getQuery().length() > 0) {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getFile() + "?" + string);
        }
        return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getFile() + "&" + string);
    }
}

