/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import launcher.GUI.GUIMCLauncher;
import launcher.a.b;
import mcedu.global.d;
import net.minecraft.launcher.GameLauncher$1;
import net.minecraft.launcher.GameLauncher$2;
import net.minecraft.launcher.GameLauncher$3;
import net.minecraft.launcher.GameLauncher$4;
import net.minecraft.launcher.GameLauncher$5;
import net.minecraft.launcher.GameLauncher$6;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.authentication.yggdrasil.YggdrasilAuthenticationService;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessLauncher;
import net.minecraft.launcher.process.JavaProcessRunnable;
import net.minecraft.launcher.profile.LauncherVisibilityRule;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.ui.tabs.CrashReportTab;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.updater.download.DownloadJob;
import net.minecraft.launcher.updater.download.DownloadListener;
import net.minecraft.launcher.updater.download.Downloadable;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ExtractRules;
import net.minecraft.launcher.versions.Library;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.lang3.text.StrSubstitutor;

public class GameLauncher
implements JavaProcessRunnable,
DownloadListener {
    private final Object lock = new Object();
    private final Launcher launcher;
    private final List<DownloadJob> jobs = new ArrayList<DownloadJob>();
    private CompleteVersion version;
    private LauncherVisibilityRule visibilityRule;
    private boolean isWorking;
    private File nativeDir;

    public GameLauncher(Launcher launcher) {
        this.launcher = launcher;
    }

    private void setWorking(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (this.nativeDir != null) {
                Launcher.getInstance().println("Deleting " + this.nativeDir);
                if (!this.nativeDir.isDirectory() || FileUtils.deleteQuietly(this.nativeDir)) {
                    this.nativeDir = null;
                } else {
                    Launcher.getInstance().println("Couldn't delete " + this.nativeDir + " - scheduling for deletion upon exit");
                    try {
                        FileUtils.forceDeleteOnExit(this.nativeDir);
                    }
                    catch (Throwable throwable) {}
                }
            }
            this.isWorking = bl;
            SwingUtilities.invokeLater(new GameLauncher$1(this));
            return;
        }
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public void playGame() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isWorking) {
                this.launcher.println("Tried to play game but game is already starting!");
                return;
            }
            this.setWorking(true);
        }
        SwingUtilities.invokeLater(new GameLauncher$2(this));
        this.launcher.println("Getting syncinfo for selected version");
        object = this.launcher.getProfileManager().getSelectedProfile();
        Object object2 = ((Profile)object).getLastVersionId();
        VersionSyncInfo versionSyncInfo = null;
        this.visibilityRule = ((Profile)object).getLauncherVisibilityOnGameClose() == null ? Profile.DEFAULT_LAUNCHER_VISIBILITY : ((Profile)object).getLauncherVisibilityOnGameClose();
        if (object2 != null) {
            versionSyncInfo = this.launcher.getVersionManager().getVersionSyncInfo((String)object2);
        }
        if (versionSyncInfo == null || versionSyncInfo.getLatestVersion() == null) {
            versionSyncInfo = this.launcher.getVersionManager().getVersions(((Profile)object).getVersionFilter()).get(0);
        }
        if (versionSyncInfo == null) {
            Launcher.getInstance().println("Tried to launch a version without a version being selected...");
            this.setWorking(false);
            return;
        }
        object = this.lock;
        synchronized (object) {
            this.launcher.println("Queueing library & version downloads");
            try {
                this.version = this.launcher.getVersionManager().getLatestCompleteVersion(versionSyncInfo);
            }
            catch (IOException iOException) {
                Launcher.getInstance().println("Couldn't get complete version info for " + versionSyncInfo.getLatestVersion(), iOException);
                this.setWorking(false);
                return;
            }
            if (!this.version.appliesToCurrentEnvironment()) {
                object2 = this.version.getIncompatibilityReason();
                if (object2 == null) {
                    object2 = "This version is incompatible with your computer. Please try another one by going into Edit Profile and selecting one through the dropdown. Sorry!";
                }
                Launcher.getInstance().println("Version " + this.version.getId() + " is incompatible with current environment: " + (String)object2);
                JOptionPane.showMessageDialog(this.launcher.getFrame(), object2, "Cannot play game", 0);
                this.setWorking(false);
                return;
            }
            if (this.version.getMinimumLauncherVersion() > 7) {
                Launcher.getInstance().println("An update to your launcher is available and is required to play " + this.version.getId() + ". Please restart your launcher.");
                this.setWorking(false);
                return;
            }
            if (!versionSyncInfo.isInstalled()) {
                try {
                    object2 = this.launcher.getVersionManager().getLocalVersionList();
                    if (object2 instanceof LocalVersionList) {
                        ((LocalVersionList)object2).saveVersion(this.version);
                        Launcher.getInstance().println("Installed " + versionSyncInfo.getLatestVersion());
                    }
                }
                catch (IOException iOException) {
                    Launcher.getInstance().println("Couldn't save version info to install " + versionSyncInfo.getLatestVersion(), iOException);
                    this.setWorking(false);
                    return;
                }
            }
            try {
                object2 = new DownloadJob("Version & Libraries", false, this);
                this.addJob((DownloadJob)object2);
                this.launcher.getVersionManager().downloadVersion(versionSyncInfo, (DownloadJob)object2);
                ((DownloadJob)object2).startDownloading(this.launcher.getVersionManager().getExecutorService());
            }
            catch (IOException iOException) {
                Launcher.getInstance().println("Couldn't get version info for " + versionSyncInfo.getLatestVersion(), iOException);
                this.setWorking(false);
                return;
            }
            return;
        }
    }

    public void launchGame() {
        String[] stringArray;
        Object object = this.launcher.getProfileManager().getSelectedProfile();
        this.version = GUIMCLauncher.a == 0 ? (CompleteVersion)this.launcher.getVersionManager().getLocalVersionList().getVersion(d.d()) : (GUIMCLauncher.a == 2 ? (CompleteVersion)this.launcher.getVersionManager().getLocalVersionList().getVersion("custom") : (CompleteVersion)this.launcher.getVersionManager().getLocalVersionList().getVersion("mceduforge"));
        System.out.println(this.version.getId());
        if (this.version == null) {
            Launcher.getInstance().println("Aborting launch; version is null?");
            return;
        }
        this.cleanOldNatives();
        this.nativeDir = new File(this.launcher.getWorkingDirectory(), "versions/" + this.version.getId() + "/" + this.version.getId() + "-natives-" + System.nanoTime());
        if (!this.nativeDir.isDirectory()) {
            this.nativeDir.mkdirs();
        }
        this.launcher.println("Unpacking natives to " + this.nativeDir);
        try {
            this.unpackNatives(this.version, this.nativeDir);
        }
        catch (IOException iOException) {
            Launcher.getInstance().println("Couldn't unpack natives!", iOException);
            return;
        }
        Object object2 = ((Profile)object).getGameDir() == null ? this.launcher.getWorkingDirectory() : ((Profile)object).getGameDir();
        Launcher.getInstance().println("Launching in " + object2);
        if (!((File)object2).exists()) {
            if (!((File)object2).mkdirs()) {
                Launcher.getInstance().println("Aborting launch; couldn't create game directory");
                return;
            }
        } else if (!((File)object2).isDirectory()) {
            Launcher.getInstance().println("Aborting launch; game directory is not actually a directory");
            return;
        }
        JavaProcessLauncher javaProcessLauncher = new JavaProcessLauncher(((Profile)object).getJavaPath(), new String[0]);
        javaProcessLauncher.directory((File)object2);
        Object object3 = new File(this.launcher.getWorkingDirectory(), "assets");
        Object object4 = OperatingSystem.getCurrentPlatform();
        if (object4.equals((Object)OperatingSystem.OSX)) {
            javaProcessLauncher.addCommands("-Xdock:icon=" + new File((File)object3, "icons/minecraft.icns").getAbsolutePath(), "-Xdock:name=Minecraft");
        } else if (object4.equals((Object)OperatingSystem.WINDOWS)) {
            javaProcessLauncher.addCommands("-XX:HeapDumpPath=MojangTricksIntelDriversForPerformance_javaw.exe_minecraft.exe.heapdump");
        }
        object4 = ((Profile)object).getJavaArgs();
        if (object4 != null) {
            javaProcessLauncher.addSplitCommands((String)object4);
        } else {
            boolean bl = "32".equals(System.getProperty("sun.arch.data.model"));
            stringArray = bl ? "-Xmx512M" : "-Xmx1G";
            javaProcessLauncher.addSplitCommands((String)stringArray);
        }
        javaProcessLauncher.addCommands("-Djava.library.path=" + this.nativeDir.getAbsolutePath());
        javaProcessLauncher.addCommands("-cp", this.constructClassPath(this.version));
        javaProcessLauncher.addCommands(this.version.getMainClass());
        Object object5 = this.launcher.getProfileManager().getAuthDatabase().getByUUID(((Profile)object).getPlayerUUID());
        stringArray = this.getMinecraftArguments(this.version, (Profile)object, (File)object2, (File)object3, (AuthenticationService)object5);
        if (stringArray == null) {
            return;
        }
        javaProcessLauncher.addCommands(stringArray);
        object2 = this.launcher.getProxy();
        object3 = this.launcher.getProxyAuth();
        if (!((Proxy)object2).equals(Proxy.NO_PROXY)) {
            object2 = (InetSocketAddress)((Proxy)object2).address();
            javaProcessLauncher.addCommands("--proxyHost", ((InetSocketAddress)object2).getHostName());
            javaProcessLauncher.addCommands("--proxyPort", Integer.toString(((InetSocketAddress)object2).getPort()));
            if (object3 != null) {
                javaProcessLauncher.addCommands("--proxyUser", ((PasswordAuthentication)object3).getUserName());
                javaProcessLauncher.addCommands("--proxyPass", new String(((PasswordAuthentication)object3).getPassword()));
            }
        }
        javaProcessLauncher.addCommands(this.launcher.getAdditionalArgs());
        if (GUIMCLauncher.b == 1) {
            javaProcessLauncher.addCommands(GUIMCLauncher.c);
        }
        if (object5 != null) {
            object5.getSelectedProfile();
        }
        if (((Profile)object).getResolution() != null) {
            javaProcessLauncher.addCommands("--width", String.valueOf(((Profile)object).getResolution().getWidth()));
            javaProcessLauncher.addCommands("--height", String.valueOf(((Profile)object).getResolution().getHeight()));
        }
        try {
            object2 = javaProcessLauncher.getFullCommands();
            object = new StringBuilder();
            boolean bl = true;
            object2 = object2.iterator();
            while (object2.hasNext()) {
                object5 = (String)object2.next();
                if (!bl) {
                    ((StringBuilder)object).append(" ");
                }
                ((StringBuilder)object).append((String)object5);
                bl = false;
            }
            Launcher.getInstance().println("Running " + ((StringBuilder)object).toString());
            object2 = javaProcessLauncher.start();
            ((JavaProcess)object2).safeSetExitRunnable(this);
            if (!b.l().a.o()) {
                System.exit(0);
            }
            if (this.visibilityRule != LauncherVisibilityRule.DO_NOTHING) {
                this.launcher.getFrame().setVisible(false);
            }
            return;
        }
        catch (IOException iOException) {
            Launcher.getInstance().println("Couldn't launch game", iOException);
            this.setWorking(false);
            return;
        }
    }

    private String[] getMinecraftArguments(CompleteVersion completeVersion, Profile profile, File file, File file2, AuthenticationService authenticationService) {
        if (completeVersion.getMinecraftArguments() == null) {
            Launcher.getInstance().println("Can't run version, missing minecraftArguments");
            this.setWorking(false);
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StrSubstitutor strSubstitutor = new StrSubstitutor(hashMap);
        String[] stringArray = completeVersion.getMinecraftArguments().split(" ");
        if (authenticationService == null) {
            authenticationService = new YggdrasilAuthenticationService();
            authenticationService.setUsername("Player" + new Random().nextInt(100000));
        }
        if (authenticationService.getSessionToken() != null && !authenticationService.getSessionToken().split("\\:")[1].isEmpty() && authenticationService.getSessionToken().split("\\:")[1] != null) {
            hashMap.put("auth_access_token", authenticationService.getSessionToken().split("\\:")[1]);
        }
        hashMap.put("auth_username", authenticationService.getUsername());
        hashMap.put("auth_session", authenticationService.getSessionToken() == null && authenticationService.canPlayOnline() ? "-" : authenticationService.getSessionToken());
        if (authenticationService.getSelectedProfile() != null) {
            hashMap.put("auth_player_name", authenticationService.getSelectedProfile().getName());
            hashMap.put("auth_uuid", authenticationService.getSelectedProfile().getId());
        } else {
            hashMap.put("auth_player_name", "Player" + new Random().nextInt(100000));
            hashMap.put("auth_uuid", new UUID(0L, 0L).toString());
        }
        hashMap.put("profile_name", profile.getName());
        hashMap.put("version_name", completeVersion.getId());
        hashMap.put("game_directory", file.getAbsolutePath());
        hashMap.put("game_assets", file2.getAbsolutePath());
        hashMap.put("assets_root", new File(this.launcher.getWorkingDirectory(), "assets").getAbsolutePath());
        hashMap.put("assets_index_name", d.d());
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = strSubstitutor.replace(stringArray[i2]);
        }
        return stringArray;
    }

    private void cleanOldNatives() {
        File[] fileArray = new File(this.launcher.getWorkingDirectory(), "versions/");
        this.launcher.println("Looking for old natives to clean up...");
        AgeFileFilter ageFileFilter = new AgeFileFilter(System.currentTimeMillis() - 3600L);
        for (File file : fileArray.listFiles(DirectoryFileFilter.DIRECTORY)) {
            for (File file2 : file.listFiles(FileFilterUtils.and(new PrefixFileFilter(file.getName() + "-natives-"), ageFileFilter))) {
                Launcher.getInstance().println("Deleting " + file2);
                FileUtils.deleteQuietly(file2);
            }
        }
    }

    private void unpackNatives(CompleteVersion iterator, File file) {
        OperatingSystem operatingSystem = OperatingSystem.getCurrentPlatform();
        iterator = ((CompleteVersion)((Object)iterator)).getRelevantLibraries();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Map<OperatingSystem, String> map = ((Library)object).getNatives();
            if (map == null || map.get((Object)operatingSystem) == null) continue;
            map = new File(this.launcher.getWorkingDirectory(), "libraries/" + ((Library)object).getArtifactPath(map.get((Object)operatingSystem)));
            map = new ZipFile((File)((Object)map));
            object = ((Library)object).getExtractRules();
            try {
                Enumeration<? extends ZipEntry> enumeration = ((ZipFile)((Object)map)).entries();
                while (enumeration.hasMoreElements()) {
                    Object object2 = enumeration.nextElement();
                    if (object != null && !((ExtractRules)object).shouldExtract(((ZipEntry)object2).getName())) continue;
                    File file2 = new File(file, ((ZipEntry)object2).getName());
                    if (file2.getParentFile() != null) {
                        file2.getParentFile().mkdirs();
                    }
                    if (((ZipEntry)object2).isDirectory()) continue;
                    object2 = new BufferedInputStream(((ZipFile)((Object)map)).getInputStream((ZipEntry)object2));
                    byte[] byArray = new byte[2048];
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    try {
                        int n2;
                        while ((n2 = ((BufferedInputStream)object2).read(byArray, 0, byArray.length)) != -1) {
                            bufferedOutputStream.write(byArray, 0, n2);
                        }
                    }
                    finally {
                        Downloadable.closeSilently(bufferedOutputStream);
                        Downloadable.closeSilently(fileOutputStream);
                        Downloadable.closeSilently((Closeable)object2);
                    }
                }
            }
            finally {
                ((ZipFile)((Object)map)).close();
            }
        }
    }

    private String constructClassPath(CompleteVersion iterator) {
        StringBuilder stringBuilder = new StringBuilder();
        iterator = ((CompleteVersion)((Object)iterator)).getClassPath(OperatingSystem.getCurrentPlatform(), this.launcher.getWorkingDirectory());
        String string = System.getProperty("path.separator");
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.isFile()) {
                throw new RuntimeException("Classpath file not found: " + file);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(file.getAbsolutePath());
        }
        return stringBuilder.toString();
    }

    @Override
    public void onJavaProcessEnded(JavaProcess object) {
        int n2 = object.getExitCode();
        if (n2 == 0) {
            Launcher.getInstance().println("Game ended with no troubles detected (exit code " + n2 + ")");
            if (this.visibilityRule == LauncherVisibilityRule.CLOSE_LAUNCHER) {
                SwingUtilities.invokeLater(new GameLauncher$3(this));
            } else if (this.visibilityRule == LauncherVisibilityRule.HIDE_LAUNCHER) {
                SwingUtilities.invokeLater(new GameLauncher$4(this));
            }
        } else {
            Object object2;
            Object object3;
            Launcher.getInstance().println("Game ended with bad state (exit code " + n2 + ")");
            SwingUtilities.invokeLater(new GameLauncher$5(this));
            String string = null;
            object = object.getSysOutLines().getItems();
            for (int i2 = ((String[])object).length - 1; i2 >= 0; --i2) {
                object3 = object[i2];
                object2 = "#@!@#";
                int n3 = ((String)object3).lastIndexOf((String)object2);
                if (n3 < 0 || n3 >= ((String)object3).length() - ((String)object2).length() - 1) continue;
                string = ((String)object3).substring(n3 + ((String)object2).length()).trim();
                break;
            }
            if (string != null) {
                File file = new File(string);
                if (file.isFile()) {
                    Launcher.getInstance().println("Crash report detected, opening: " + string);
                    object3 = null;
                    try {
                        object3 = new FileInputStream(file);
                        object2 = new BufferedReader(new InputStreamReader((InputStream)object3));
                        StringBuilder stringBuilder = new StringBuilder();
                        while ((object = ((BufferedReader)object2).readLine()) != null) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append("\n");
                            }
                            stringBuilder.append((String)object);
                        }
                        ((BufferedReader)object2).close();
                        this.launcher.getLauncherPanel().getTabPanel().setCrashReport(new CrashReportTab(this.launcher, this.version, file, stringBuilder.toString()));
                    }
                    catch (IOException iOException) {
                        Launcher.getInstance().println("Couldn't open crash report", iOException);
                    }
                    finally {
                        Downloadable.closeSilently((Closeable)object3);
                    }
                } else {
                    Launcher.getInstance().println("Crash report detected, but unknown format: " + string);
                }
            }
        }
        this.setWorking(false);
    }

    @Override
    public void onDownloadJobFinished(DownloadJob downloadJob) {
        this.updateProgressBar();
        Object object = this.lock;
        synchronized (object) {
            if (downloadJob.getFailures() > 0) {
                this.launcher.println("Job '" + downloadJob.getName() + "' finished with " + downloadJob.getFailures() + " failure(s)!");
                this.setWorking(false);
            } else {
                this.launcher.println("Job '" + downloadJob.getName() + "' finished successfully");
                if (this.isWorking() && !this.hasRemainingJobs()) {
                    try {
                        this.launchGame();
                    }
                    catch (Throwable throwable) {
                        Launcher.getInstance().println("Fatal error launching game. Report this to http://mojang.atlassian.net please!", throwable);
                    }
                }
            }
            return;
        }
    }

    @Override
    public void onDownloadJobProgressChanged(DownloadJob downloadJob) {
        this.updateProgressBar();
    }

    protected void updateProgressBar() {
        float f2 = this.getProgress();
        boolean bl = this.hasRemainingJobs();
        SwingUtilities.invokeLater(new GameLauncher$6(this, bl, f2));
    }

    protected float getProgress() {
        Object object = this.lock;
        synchronized (object) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (DownloadJob downloadJob : this.jobs) {
                float f4;
                float f5 = downloadJob.getProgress();
                if (!(f4 >= 0.0f)) continue;
                f3 += f5;
                f2 += 1.0f;
            }
            return f3 / f2;
        }
    }

    public boolean hasRemainingJobs() {
        Object object = this.lock;
        synchronized (object) {
            for (DownloadJob downloadJob : this.jobs) {
                if (downloadJob.isComplete()) continue;
                return true;
            }
        }
        return false;
    }

    public void addJob(DownloadJob downloadJob) {
        Object object = this.lock;
        synchronized (object) {
            this.jobs.add(downloadJob);
            return;
        }
    }

    static /* synthetic */ Launcher a(GameLauncher gameLauncher) {
        return gameLauncher.launcher;
    }
}

