/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import com.google.common.base.Throwables;
import cpw.mods.fml.relauncher.FMLLogFormatter;
import cpw.mods.fml.relauncher.FMLRelaunchLog$1;
import cpw.mods.fml.relauncher.FMLRelaunchLog$ConsoleLogThread;
import cpw.mods.fml.relauncher.FMLRelaunchLog$ConsoleLogWrapper;
import cpw.mods.fml.relauncher.FMLRelaunchLog$LoggingOutStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class FMLRelaunchLog {
    public static FMLRelaunchLog log = new FMLRelaunchLog();
    private static File minecraftHome;
    private static boolean configured;
    private static Thread consoleLogThread;
    private static PrintStream errCache;
    private Logger myLog;
    private static FileHandler fileHandler;
    private static FMLLogFormatter formatter;
    private static String logFileNamePattern;

    private FMLRelaunchLog() {
    }

    private static void configureLogging() {
        LogManager.getLogManager().reset();
        Logger logger = Logger.getLogger("global");
        logger.setLevel(Level.OFF);
        FMLRelaunchLog.log.myLog = Logger.getLogger("ForgeModLoader");
        logger = Logger.getLogger("STDOUT");
        logger.setParent(FMLRelaunchLog.log.myLog);
        Logger logger2 = Logger.getLogger("STDERR");
        logger2.setParent(FMLRelaunchLog.log.myLog);
        FMLRelaunchLog.log.myLog.setLevel(Level.ALL);
        FMLRelaunchLog.log.myLog.setUseParentHandlers(false);
        consoleLogThread = new Thread(new FMLRelaunchLog$ConsoleLogThread());
        consoleLogThread.setDaemon(true);
        consoleLogThread.start();
        formatter = new FMLLogFormatter();
        try {
            File file = new File(null, null);
            fileHandler = new FMLRelaunchLog$1(file.getPath(), 0, 3);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw Throwables.propagate(throwable);
        }
        FMLRelaunchLog.resetLoggingHandlers();
        errCache = System.err;
        System.setOut(new PrintStream(new FMLRelaunchLog$LoggingOutStream(logger), true));
        System.setErr(new PrintStream(new FMLRelaunchLog$LoggingOutStream(logger2), true));
        configured = true;
    }

    private static void resetLoggingHandlers() {
        FMLRelaunchLog$ConsoleLogThread.a.setLevel(Level.parse(System.getProperty("fml.log.level", "INFO")));
        FMLRelaunchLog.log.myLog.addHandler(new FMLRelaunchLog$ConsoleLogWrapper());
        FMLRelaunchLog$ConsoleLogThread.a.setFormatter(formatter);
        fileHandler.setLevel(Level.ALL);
        fileHandler.setFormatter(formatter);
        FMLRelaunchLog.log.myLog.addHandler(fileHandler);
    }

    public static void loadLogConfiguration(File file) {
        if (file != null && file.exists() && file.canRead()) {
            try {
                LogManager.getLogManager().readConfiguration(new FileInputStream(file));
                FMLRelaunchLog.resetLoggingHandlers();
                return;
            }
            catch (Exception exception) {
                FMLRelaunchLog.log(Level.SEVERE, exception, "Error reading logging configuration file %s", file.getName());
            }
        }
    }

    public static void log(String string, Level level, String string2, Object ... objectArray) {
        FMLRelaunchLog.makeLog(string);
        Logger.getLogger(string).log(level, String.format(string2, objectArray));
    }

    public static void log(Level level, String string, Object ... objectArray) {
        if (!configured) {
            FMLRelaunchLog.configureLogging();
        }
        FMLRelaunchLog.log.myLog.log(level, String.format(string, objectArray));
    }

    public static void log(String string, Level level, Throwable throwable, String string2, Object ... objectArray) {
        FMLRelaunchLog.makeLog(string);
        Logger.getLogger(string).log(level, String.format(string2, objectArray), throwable);
    }

    public static void log(Level level, Throwable throwable, String string, Object ... objectArray) {
        if (!configured) {
            FMLRelaunchLog.configureLogging();
        }
        FMLRelaunchLog.log.myLog.log(level, String.format(string, objectArray), throwable);
    }

    public static void severe(String string, Object ... objectArray) {
        FMLRelaunchLog.log(Level.SEVERE, string, objectArray);
    }

    public static void warning(String string, Object ... objectArray) {
        FMLRelaunchLog.log(Level.WARNING, string, objectArray);
    }

    public static void info(String string, Object ... objectArray) {
        FMLRelaunchLog.log(Level.INFO, string, objectArray);
    }

    public static void fine(String string, Object ... objectArray) {
        FMLRelaunchLog.log(Level.FINE, string, objectArray);
    }

    public static void finer(String string, Object ... objectArray) {
        FMLRelaunchLog.log(Level.FINER, string, objectArray);
    }

    public static void finest(String string, Object ... objectArray) {
        FMLRelaunchLog.log(Level.FINEST, string, objectArray);
    }

    public Logger getLogger() {
        return this.myLog;
    }

    public static void makeLog(String object) {
        object = Logger.getLogger((String)object);
        ((Logger)object).setParent(FMLRelaunchLog.log.myLog);
    }

    static /* synthetic */ PrintStream a() {
        return errCache;
    }
}

