/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.versioning;

import com.google.common.base.Joiner;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.common.versioning.Restriction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VersionRange {
    private final ArtifactVersion recommendedVersion;
    private final List<Restriction> restrictions;

    private VersionRange(ArtifactVersion artifactVersion, List<Restriction> list) {
        this.recommendedVersion = artifactVersion;
        this.restrictions = list;
    }

    public ArtifactVersion getRecommendedVersion() {
        return this.recommendedVersion;
    }

    public List<Restriction> getRestrictions() {
        return this.restrictions;
    }

    public VersionRange cloneOf() {
        ArrayList<Restriction> arrayList = null;
        if (this.restrictions != null) {
            arrayList = new ArrayList<Restriction>();
            if (!this.restrictions.isEmpty()) {
                arrayList.addAll(this.restrictions);
            }
        }
        return new VersionRange(this.recommendedVersion, arrayList);
    }

    public static VersionRange createFromVersionSpec(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<Restriction> arrayList = new ArrayList<Restriction>();
        String string2 = string;
        DefaultArtifactVersion defaultArtifactVersion = null;
        ArtifactVersion artifactVersion = null;
        ArtifactVersion artifactVersion2 = null;
        while (string2.startsWith("[") || string2.startsWith("(")) {
            int n2;
            int n3 = string2.indexOf(")");
            int n4 = n2 = string2.indexOf("]");
            if ((n2 < 0 || n3 < n2) && n3 >= 0) {
                n4 = n3;
            }
            if (n4 < 0) {
                throw new InvalidVersionSpecificationException("Unbounded range: " + string);
            }
            Restriction restriction = VersionRange.parseRestriction(string2.substring(0, n4 + 1));
            if (artifactVersion2 == null) {
                artifactVersion2 = restriction.getLowerBound();
            }
            if (artifactVersion != null && (restriction.getLowerBound() == null || restriction.getLowerBound().compareTo(artifactVersion) < 0)) {
                throw new InvalidVersionSpecificationException("Ranges overlap: " + string);
            }
            arrayList.add(restriction);
            artifactVersion = restriction.getUpperBound();
            if ((string2 = string2.substring(n4 + 1).trim()).length() <= 0 || !string2.startsWith(",")) continue;
            string2 = string2.substring(1).trim();
        }
        if (string2.length() > 0) {
            if (arrayList.size() > 0) {
                throw new InvalidVersionSpecificationException("Only fully-qualified sets allowed in multiple set scenario: " + string);
            }
            defaultArtifactVersion = new DefaultArtifactVersion(string2);
            arrayList.add(Restriction.EVERYTHING);
        }
        return new VersionRange(defaultArtifactVersion, arrayList);
    }

    private static Restriction parseRestriction(String object) {
        boolean bl = ((String)object).startsWith("[");
        boolean bl2 = ((String)object).endsWith("]");
        String string = ((String)object).substring(1, ((String)object).length() - 1).trim();
        int n2 = string.indexOf(",");
        if (n2 < 0) {
            if (!bl || !bl2) {
                throw new InvalidVersionSpecificationException("Single version must be surrounded by []: " + (String)object);
            }
            DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(string);
            object = new Restriction(defaultArtifactVersion, bl, defaultArtifactVersion, bl2);
        } else {
            Object object2 = string.substring(0, n2).trim();
            if (((String)object2).equals(string = string.substring(n2 + 1).trim())) {
                throw new InvalidVersionSpecificationException("Range cannot have identical boundaries: " + (String)object);
            }
            DefaultArtifactVersion defaultArtifactVersion = null;
            if (((String)object2).length() > 0) {
                defaultArtifactVersion = new DefaultArtifactVersion((String)object2);
            }
            object2 = null;
            if (string.length() > 0) {
                object2 = new DefaultArtifactVersion(string);
            }
            if (object2 != null && defaultArtifactVersion != null && object2.compareTo(defaultArtifactVersion) < 0) {
                throw new InvalidVersionSpecificationException("Range defies version ordering: " + (String)object);
            }
            object = new Restriction(defaultArtifactVersion, bl, (ArtifactVersion)object2, bl2);
        }
        return object;
    }

    public static VersionRange createFromVersion(String string, ArtifactVersion artifactVersion) {
        List<Restriction> list = Collections.emptyList();
        if (artifactVersion == null) {
            artifactVersion = new DefaultArtifactVersion(string);
        }
        return new VersionRange(artifactVersion, list);
    }

    public VersionRange restrict(VersionRange versionRange) {
        List<Restriction> list = this.restrictions;
        Object object = versionRange.restrictions;
        list = list.isEmpty() || object.isEmpty() ? Collections.emptyList() : this.intersection(list, (List<Restriction>)object);
        object = null;
        if (list.size() > 0) {
            for (Restriction restriction : list) {
                if (this.recommendedVersion != null && restriction.containsVersion(this.recommendedVersion)) {
                    object = this.recommendedVersion;
                    break;
                }
                if (object != null || versionRange.getRecommendedVersion() == null || !restriction.containsVersion(versionRange.getRecommendedVersion())) continue;
                object = versionRange.getRecommendedVersion();
            }
        } else if (this.recommendedVersion != null) {
            object = this.recommendedVersion;
        } else if (versionRange.recommendedVersion != null) {
            object = versionRange.recommendedVersion;
        }
        return new VersionRange((ArtifactVersion)object, list);
    }

    /*
     * Unable to fully structure code
     */
    private List<Restriction> intersection(List<Restriction> var1_1, List<Restriction> var2_2) {
        var3_3 = new ArrayList<Restriction>(var1_1.size() + var2_2.size());
        var1_1 = var1_1.iterator();
        var2_2 = var2_2.iterator();
        var4_4 = (Restriction)var1_1.next();
        var5_5 = (Restriction)var2_2.next();
        var6_6 = false;
        while (!var6_6) {
            block19: {
                block20: {
                    block22: {
                        block21: {
                            if (var4_4.getLowerBound() != null && var5_5.getUpperBound() != null && var4_4.getLowerBound().compareTo(var5_5.getUpperBound()) > 0) break block19;
                            if (var4_4.getUpperBound() != null && var5_5.getLowerBound() != null && var4_4.getUpperBound().compareTo(var5_5.getLowerBound()) < 0) break block20;
                            if (var4_4.getLowerBound() != null) break block21;
                            var7_7 = var5_5.getLowerBound();
                            var9_10 = var5_5.isLowerBoundInclusive();
                            break block22;
                        }
                        if (var5_5.getLowerBound() == null) ** GOTO lbl-1000
                        var8_9 = var4_4.getLowerBound().compareTo(var5_5.getLowerBound());
                        if (var8_9 < 0) {
                            var7_7 = var5_5.getLowerBound();
                            var9_10 = var5_5.isLowerBoundInclusive();
                        } else if (var8_9 == 0) {
                            var7_7 = var4_4.getLowerBound();
                            var9_10 = var4_4.isLowerBoundInclusive() != false && var5_5.isLowerBoundInclusive() != false;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var7_7 = var4_4.getLowerBound();
                            var9_10 = var4_4.isLowerBoundInclusive();
                        }
                    }
                    if (var4_4.getUpperBound() == null) ** GOTO lbl-1000
                    if (var5_5.getUpperBound() == null) {
                        var8_8 = var4_4.getUpperBound();
                        var10_11 = var4_4.isUpperBoundInclusive();
                    } else {
                        var8_9 = var4_4.getUpperBound().compareTo(var5_5.getUpperBound());
                        if (var8_9 < 0) {
                            var8_8 = var4_4.getUpperBound();
                            var10_11 = var4_4.isUpperBoundInclusive();
                        } else if (var8_9 == 0) {
                            var8_8 = var4_4.getUpperBound();
                            var10_11 = var4_4.isUpperBoundInclusive() != false && var5_5.isUpperBoundInclusive() != false;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var8_8 = var5_5.getUpperBound();
                            var10_11 = var5_5.isUpperBoundInclusive();
                        }
                    }
                    if (var7_7 == null || var8_8 == null || var7_7.compareTo(var8_8) != 0) {
                        var3_3.add(new Restriction(var7_7, var9_10, var8_8, var10_11));
                    } else if (var9_10 && var10_11) {
                        var3_3.add(new Restriction(var7_7, var9_10, var8_8, var10_11));
                    }
                    if (var8_8 == var5_5.getUpperBound()) {
                        if (var2_2.hasNext()) {
                            var5_5 = (Restriction)var2_2.next();
                            continue;
                        }
                        var6_6 = true;
                        continue;
                    }
                    if (var1_1.hasNext()) {
                        var4_4 = (Restriction)var1_1.next();
                        continue;
                    }
                    var6_6 = true;
                    continue;
                }
                if (var1_1.hasNext()) {
                    var4_4 = (Restriction)var1_1.next();
                    continue;
                }
                var6_6 = true;
                continue;
            }
            if (var2_2.hasNext()) {
                var5_5 = (Restriction)var2_2.next();
                continue;
            }
            var6_6 = true;
        }
        return var3_3;
    }

    public final String toString() {
        if (this.recommendedVersion != null) {
            return this.recommendedVersion.toString();
        }
        return Joiner.on(',').join(this.restrictions);
    }

    public ArtifactVersion matchVersion(List<ArtifactVersion> object) {
        ArtifactVersion artifactVersion = null;
        object = object.iterator();
        while (object.hasNext()) {
            ArtifactVersion artifactVersion2 = (ArtifactVersion)object.next();
            if (!this.containsVersion(artifactVersion2) || artifactVersion != null && artifactVersion2.compareTo(artifactVersion) <= 0) continue;
            artifactVersion = artifactVersion2;
        }
        return artifactVersion;
    }

    public boolean containsVersion(ArtifactVersion artifactVersion) {
        for (Restriction restriction : this.restrictions) {
            if (!restriction.containsVersion(artifactVersion)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRestrictions() {
        return !this.restrictions.isEmpty() && this.recommendedVersion == null;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VersionRange)) {
            return false;
        }
        object = (VersionRange)object;
        boolean bl = this.recommendedVersion == ((VersionRange)object).recommendedVersion || this.recommendedVersion != null && this.recommendedVersion.equals(((VersionRange)object).recommendedVersion);
        bl = bl & (this.restrictions == ((VersionRange)object).restrictions || this.restrictions != null && ((Object)this.restrictions).equals(((VersionRange)object).restrictions));
        return bl;
    }

    public final int hashCode() {
        int n2 = 217 + (this.recommendedVersion == null ? 0 : this.recommendedVersion.hashCode());
        n2 = n2 * 31 + (this.restrictions == null ? 0 : ((Object)this.restrictions).hashCode());
        return n2;
    }

    public boolean isUnboundedAbove() {
        return this.restrictions.size() == 1 && this.restrictions.get(0).getUpperBound() == null && !this.restrictions.get(0).isUpperBoundInclusive();
    }

    public String getLowerBoundString() {
        if (this.restrictions.size() == 1) {
            return this.restrictions.get(0).getLowerBound().getVersionString();
        }
        return "";
    }
}

