/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.versioning;

import cpw.mods.fml.common.versioning.ArtifactVersion;

public class Restriction {
    private final ArtifactVersion lowerBound;
    private final boolean lowerBoundInclusive;
    private final ArtifactVersion upperBound;
    private final boolean upperBoundInclusive;
    public static final Restriction EVERYTHING = new Restriction(null, false, null, false);

    public Restriction(ArtifactVersion artifactVersion, boolean bl, ArtifactVersion artifactVersion2, boolean bl2) {
        this.lowerBound = artifactVersion;
        this.lowerBoundInclusive = bl;
        this.upperBound = artifactVersion2;
        this.upperBoundInclusive = bl2;
    }

    public ArtifactVersion getLowerBound() {
        return this.lowerBound;
    }

    public boolean isLowerBoundInclusive() {
        return this.lowerBoundInclusive;
    }

    public ArtifactVersion getUpperBound() {
        return this.upperBound;
    }

    public boolean isUpperBoundInclusive() {
        return this.upperBoundInclusive;
    }

    public boolean containsVersion(ArtifactVersion artifactVersion) {
        int n2;
        if (this.lowerBound != null) {
            n2 = this.lowerBound.compareTo(artifactVersion);
            if (n2 == 0 && !this.lowerBoundInclusive) {
                return false;
            }
            if (n2 > 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            n2 = this.upperBound.compareTo(artifactVersion);
            if (n2 == 0 && !this.upperBoundInclusive) {
                return false;
            }
            if (n2 < 0) {
                return false;
            }
        }
        return true;
    }

    public final int hashCode() {
        int n2 = 13;
        n2 = this.lowerBound == null ? ++n2 : 13 + this.lowerBound.hashCode();
        n2 *= this.lowerBoundInclusive ? 1 : 2;
        n2 = this.upperBound == null ? (n2 -= 3) : (n2 -= this.upperBound.hashCode());
        return n2 *= this.upperBoundInclusive ? 2 : 3;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Restriction)) {
            return false;
        }
        object = (Restriction)object;
        if (this.lowerBound != null ? !this.lowerBound.equals(((Restriction)object).lowerBound) : ((Restriction)object).lowerBound != null) {
            return false;
        }
        if (this.lowerBoundInclusive != ((Restriction)object).lowerBoundInclusive) {
            return false;
        }
        if (this.upperBound != null ? !this.upperBound.equals(((Restriction)object).upperBound) : ((Restriction)object).upperBound != null) {
            return false;
        }
        return this.upperBoundInclusive == ((Restriction)object).upperBoundInclusive;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.isLowerBoundInclusive() ? "[" : "(");
        if (this.getLowerBound() != null) {
            stringBuilder.append(this.getLowerBound().toString());
        }
        stringBuilder.append(",");
        if (this.getUpperBound() != null) {
            stringBuilder.append(this.getUpperBound().toString());
        }
        stringBuilder.append(this.isUpperBoundInclusive() ? "]" : ")");
        return stringBuilder.toString();
    }
}

