/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.versioning;

import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.ComparableVersion;
import cpw.mods.fml.common.versioning.VersionRange;

public class DefaultArtifactVersion
implements ArtifactVersion {
    private ComparableVersion comparableVersion;
    private String label;
    private boolean unbounded;
    private VersionRange range;

    public DefaultArtifactVersion(String string) {
        this.comparableVersion = new ComparableVersion(string);
        this.range = VersionRange.createFromVersion(string, this);
    }

    public DefaultArtifactVersion(String string, VersionRange versionRange) {
        this.label = string;
        this.range = versionRange;
    }

    public DefaultArtifactVersion(String string, String string2) {
        this(string2);
        this.label = string;
    }

    public DefaultArtifactVersion(String string, boolean bl) {
        this.label = string;
        this.unbounded = true;
    }

    public final boolean equals(Object object) {
        return ((DefaultArtifactVersion)object).containsVersion(this);
    }

    @Override
    public int compareTo(ArtifactVersion artifactVersion) {
        if (this.unbounded) {
            return 0;
        }
        return this.comparableVersion.compareTo(((DefaultArtifactVersion)artifactVersion).comparableVersion);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean containsVersion(ArtifactVersion artifactVersion) {
        if (!artifactVersion.getLabel().equals(this.getLabel())) {
            return false;
        }
        if (this.unbounded) {
            return true;
        }
        if (this.range != null) {
            return this.range.containsVersion(artifactVersion);
        }
        return false;
    }

    @Override
    public String getVersionString() {
        if (this.comparableVersion == null) {
            return "unknown";
        }
        return this.comparableVersion.toString();
    }

    @Override
    public String getRangeString() {
        if (this.range == null) {
            return "any";
        }
        return this.range.toString();
    }

    public final String toString() {
        if (this.label == null) {
            return this.comparableVersion.toString();
        }
        return this.label + (this.unbounded ? "" : "@" + this.range);
    }

    public VersionRange getRange() {
        return this.range;
    }
}

