/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.toposort;

import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.toposort.TopologicalSort;
import cpw.mods.fml.common.toposort.TopologicalSort$DirectedGraph;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ModSorter {
    private TopologicalSort$DirectedGraph<ModContainer> modGraph;
    private ModContainer beforeAll = new DummyModContainer("BeforeAll");
    private ModContainer afterAll = new DummyModContainer("AfterAll");
    private ModContainer before = new DummyModContainer("Before");
    private ModContainer after = new DummyModContainer("After");

    public ModSorter(List<ModContainer> list, Map<String, ModContainer> map) {
        this.buildGraph(list, map);
    }

    private void buildGraph(List<ModContainer> list, Map<String, ModContainer> map) {
        this.modGraph = new TopologicalSort$DirectedGraph();
        this.modGraph.addNode(this.beforeAll);
        this.modGraph.addNode(this.before);
        this.modGraph.addNode(this.afterAll);
        this.modGraph.addNode(this.after);
        this.modGraph.addEdge(this.before, this.after);
        this.modGraph.addEdge(this.beforeAll, this.before);
        this.modGraph.addEdge(this.after, this.afterAll);
        for (ModContainer modContainer : list) {
            this.modGraph.addNode(modContainer);
        }
        for (ModContainer modContainer : list) {
            if (modContainer.isImmutable()) {
                this.modGraph.addEdge(this.beforeAll, modContainer);
                this.modGraph.addEdge(modContainer, this.before);
                continue;
            }
            boolean bl = false;
            boolean bl2 = false;
            for (ArtifactVersion artifactVersion : modContainer.getDependencies()) {
                bl = true;
                String string = artifactVersion.getLabel();
                if (string.equals("*")) {
                    this.modGraph.addEdge(modContainer, this.afterAll);
                    this.modGraph.addEdge(this.after, modContainer);
                    bl2 = true;
                    continue;
                }
                this.modGraph.addEdge(this.before, modContainer);
                if (!Loader.isModLoaded(string)) continue;
                this.modGraph.addEdge(map.get(string), modContainer);
            }
            for (ArtifactVersion artifactVersion : modContainer.getDependants()) {
                bl2 = true;
                String string = artifactVersion.getLabel();
                if (string.equals("*")) {
                    this.modGraph.addEdge(this.beforeAll, modContainer);
                    this.modGraph.addEdge(modContainer, this.before);
                    bl = true;
                    continue;
                }
                this.modGraph.addEdge(modContainer, this.after);
                if (!Loader.isModLoaded(string)) continue;
                this.modGraph.addEdge(modContainer, map.get(string));
            }
            if (!bl) {
                this.modGraph.addEdge(this.before, modContainer);
            }
            if (bl2) continue;
            this.modGraph.addEdge(modContainer, this.after);
        }
    }

    public List<ModContainer> sort() {
        List<ModContainer> list = TopologicalSort.topologicalSort(this.modGraph);
        list.removeAll(Arrays.asList(this.beforeAll, this.before, this.after, this.afterAll));
        return list;
    }
}

