/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.modloader;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.discovery.ContainerType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.modloader.BaseModProxy;
import cpw.mods.fml.common.modloader.ModProperty;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionRange;
import java.io.File;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModLoaderModContainer
implements ModContainer {
    public BaseModProxy mod;
    private File modSource;
    public Set<ArtifactVersion> requirements = Sets.newHashSet();
    public ArrayList<ArtifactVersion> dependencies = Lists.newArrayList();
    public ArrayList<ArtifactVersion> dependants = Lists.newArrayList();
    private ContainerType sourceType;
    private ModMetadata metadata;
    private String modClazzName;
    private String modId;
    private EventBus bus;
    private LoadController controller;
    private boolean enabled = true;
    private String sortingProperties;
    private ArtifactVersion processedVersion;
    private boolean isNetworkMod;

    public ModLoaderModContainer(String string, File file, String string2) {
        this.modClazzName = string;
        this.modSource = file;
        this.modId = string.contains(".") ? string.substring(string.lastIndexOf(46) + 1) : string;
        this.sortingProperties = Strings.isNullOrEmpty(string2) ? "" : string2;
    }

    private Object parseValue(String object, ModProperty modProperty, Class<?> clazz, String string) {
        if (clazz.isAssignableFrom(String.class)) {
            return object;
        }
        if (clazz.isAssignableFrom(Boolean.TYPE) || clazz.isAssignableFrom(Boolean.class)) {
            return Boolean.parseBoolean((String)object);
        }
        if (Number.class.isAssignableFrom(clazz) || clazz.isPrimitive()) {
            if (clazz.isAssignableFrom(Double.TYPE) || Double.class.isAssignableFrom(clazz)) {
                object = Double.parseDouble((String)object);
            } else if (clazz.isAssignableFrom(Float.TYPE) || Float.class.isAssignableFrom(clazz)) {
                object = Float.valueOf(Float.parseFloat((String)object));
            } else if (clazz.isAssignableFrom(Long.TYPE) || Long.class.isAssignableFrom(clazz)) {
                object = Long.parseLong((String)object);
            } else if (clazz.isAssignableFrom(Integer.TYPE) || Integer.class.isAssignableFrom(clazz)) {
                object = Integer.parseInt((String)object);
            } else if (clazz.isAssignableFrom(Short.TYPE) || Short.class.isAssignableFrom(clazz)) {
                object = Short.parseShort((String)object);
            } else if (clazz.isAssignableFrom(Byte.TYPE) || Byte.class.isAssignableFrom(clazz)) {
                object = Byte.parseByte((String)object);
            } else {
                throw new IllegalArgumentException(String.format("MLProp declared on %s of type %s, an unsupported type", string, clazz.getName()));
            }
            double d2 = ((Number)object).doubleValue();
            if (modProperty.min() != Double.MIN_VALUE && d2 < modProperty.min() || modProperty.max() != Double.MAX_VALUE && d2 > modProperty.max()) {
                FMLLog.warning("Configuration for %s.%s found value %s outside acceptable range %s,%s", this.modClazzName, string, object, modProperty.min(), modProperty.max());
                return null;
            }
            return object;
        }
        throw new IllegalArgumentException(String.format("MLProp declared on %s of type %s, an unsupported type", string, clazz.getName()));
    }

    private String extractValue(Object object) {
        if (String.class.isInstance(object)) {
            return (String)object;
        }
        if (Number.class.isInstance(object) || Boolean.class.isInstance(object)) {
            return String.valueOf(object);
        }
        throw new IllegalArgumentException("MLProp declared on non-standard type");
    }

    @Override
    public String getName() {
        if (this.mod != null) {
            return this.mod.getName();
        }
        return this.modId;
    }

    @Override
    public String getSortingRules() {
        return this.sortingProperties;
    }

    @Override
    public boolean matches(Object object) {
        return this.mod == object;
    }

    @Override
    public File getSource() {
        return this.modSource;
    }

    @Override
    public Object getMod() {
        return this.mod;
    }

    @Override
    public Set<ArtifactVersion> getRequirements() {
        return this.requirements;
    }

    @Override
    public List<ArtifactVersion> getDependants() {
        return this.dependants;
    }

    @Override
    public List<ArtifactVersion> getDependencies() {
        return this.dependencies;
    }

    public final String toString() {
        return this.modId;
    }

    @Override
    public ModMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getVersion() {
        if (this.mod == null || this.mod.getVersion() == null) {
            return "Not available";
        }
        return this.mod.getVersion();
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public void bindMetadata(MetadataCollection metadataCollection) {
        ImmutableMap<String, Object> immutableMap = ImmutableMap.builder().put("name", this.modId).put("version", "1.0").build();
        this.metadata = metadataCollection.getMetadataForId(this.modId, immutableMap);
        Loader.instance().computeDependencies(this.sortingProperties, this.getRequirements(), this.getDependencies(), this.getDependants());
    }

    @Override
    public void setEnabledState(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean registerBus(EventBus eventBus, LoadController loadController) {
        if (this.enabled) {
            FMLLog.fine("Enabling mod %s", this.getModId());
            this.bus = eventBus;
            this.controller = loadController;
            eventBus.register(this);
            return true;
        }
        return false;
    }

    public void init(FMLInitializationEvent fMLInitializationEvent) {
        try {
            this.mod.load();
            return;
        }
        catch (Throwable throwable) {
            this.controller.errorOccurred(this, throwable);
            Throwables.propagateIfPossible(throwable);
            return;
        }
    }

    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        try {
            this.mod.modsLoaded();
            return;
        }
        catch (Throwable throwable) {
            this.controller.errorOccurred(this, throwable);
            Throwables.propagateIfPossible(throwable);
            return;
        }
    }

    public void loadComplete(FMLLoadCompleteEvent fMLLoadCompleteEvent) {
    }

    @Override
    public ArtifactVersion getProcessedVersion() {
        if (this.processedVersion == null) {
            this.processedVersion = new DefaultArtifactVersion(this.modId, this.getVersion());
        }
        return this.processedVersion;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isNetworkMod() {
        return this.isNetworkMod;
    }

    @Override
    public String getDisplayVersion() {
        if (this.metadata != null) {
            return this.metadata.version;
        }
        return this.getVersion();
    }

    @Override
    public VersionRange acceptableMinecraftVersionRange() {
        return Loader.instance().getMinecraftModContainer().getStaticVersionRange();
    }

    @Override
    public Certificate getSigningCertificate() {
        return null;
    }

    @Override
    public Map<String, String> getCustomModProperties() {
        return EMPTY_PROPERTIES;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return null;
    }

    @Override
    public Map<String, String> getSharedModDescriptor() {
        HashMap<String, String> hashMap = Maps.newHashMap();
        hashMap.put("modsystem", "ModLoader");
        hashMap.put("id", this.getModId());
        hashMap.put("version", this.getDisplayVersion());
        hashMap.put("name", this.getName());
        hashMap.put("url", this.metadata.url);
        hashMap.put("authors", this.metadata.getAuthorList());
        hashMap.put("description", this.metadata.description);
        return hashMap;
    }
}

