/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ContainerType;
import cpw.mods.fml.common.discovery.ModCandidate;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModDiscoverer {
    private static Pattern zipJar = Pattern.compile("(.+).(zip|jar)$");
    private List<ModCandidate> candidates = Lists.newArrayList();
    private ASMDataTable dataTable = new ASMDataTable();
    private List<File> nonModLibs = Lists.newArrayList();

    public void findModDirMods(File objectArray) {
        objectArray = objectArray.listFiles();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            if (((File)object).isDirectory()) {
                this.candidates.add(new ModCandidate((File)object, (File)object, ContainerType.DIR));
                continue;
            }
            Matcher matcher = zipJar.matcher(((File)object).getName());
            if (!matcher.matches()) continue;
            this.candidates.add(new ModCandidate((File)object, (File)object, ContainerType.JAR));
        }
    }

    public List<ModContainer> identifyMods() {
        ArrayList<ModContainer> arrayList = Lists.newArrayList();
        for (ModCandidate modCandidate : this.candidates) {
            Object object;
            try {
                object = modCandidate.explore(this.dataTable);
                if (object.isEmpty() && !modCandidate.isClasspath()) {
                    this.nonModLibs.add(modCandidate.getModContainer());
                    continue;
                }
                arrayList.addAll((Collection<ModContainer>)object);
            }
            catch (LoaderException loaderException) {
                System.out.println(loaderException.getMessage());
            }
            catch (Throwable throwable) {
                object = throwable;
                Throwables.propagate(throwable);
            }
        }
        return arrayList;
    }

    public ASMDataTable getASMTable() {
        return this.dataTable;
    }

    public List<File> getNonModLibs() {
        return this.nonModLibs;
    }
}

