/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModContainerFactory;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.DirectoryDiscoverer$ClassFilter;
import cpw.mods.fml.common.discovery.ITypeDiscoverer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;

public class DirectoryDiscoverer
implements ITypeDiscoverer {
    private ASMDataTable table;

    @Override
    public List<ModContainer> discover(ModCandidate object, ASMDataTable aSMDataTable) {
        this.table = aSMDataTable;
        ArrayList<ModContainer> arrayList = Lists.newArrayList();
        this.exploreFileSystem("", ((ModCandidate)object).getModContainer(), arrayList, (ModCandidate)object, null);
        for (ModContainer modContainer : arrayList) {
            aSMDataTable.addContainer(modContainer);
        }
        return arrayList;
    }

    public void exploreFileSystem(String string, File file, List<ModContainer> list, ModCandidate modCandidate, MetadataCollection metadataCollection) {
        Object object;
        if (string.length() == 0) {
            object = new File(file, "mcmod.info");
            try {
                object = new FileInputStream((File)object);
                metadataCollection = MetadataCollection.from((InputStream)object, file.getName());
                ((FileInputStream)object).close();
            }
            catch (Exception exception) {
                metadataCollection = MetadataCollection.from(null, "");
            }
        }
        object = file.listFiles(new DirectoryDiscoverer$ClassFilter(this));
        Arrays.sort((Object[])object);
        for (Object object2 : object) {
            Object object3;
            if (((File)object2).isDirectory()) {
                this.exploreFileSystem(string + ((File)object2).getName() + ".", (File)object2, list, modCandidate, metadataCollection);
                continue;
            }
            Object object4 = classFile.matcher(((File)object2).getName());
            if (!((Matcher)object4).matches()) continue;
            object4 = null;
            try {
                object3 = new FileInputStream((File)object2);
                object4 = new ASMModParser((InputStream)object3);
                ((FileInputStream)object3).close();
                modCandidate.addClassEntry(string + ((File)object2).getName());
            }
            catch (LoaderException loaderException) {
                object3 = loaderException;
                throw loaderException;
            }
            catch (Exception exception) {
                object3 = exception;
                Throwables.propagate(exception);
            }
            ((ASMModParser)object4).validate();
            ((ASMModParser)object4).sendToTable(this.table, modCandidate);
            object3 = ModContainerFactory.instance().build((ASMModParser)object4, modCandidate.getModContainer(), modCandidate);
            if (object3 == null) continue;
            list.add((ModContainer)object3);
            object3.bindMetadata(metadataCollection);
        }
    }
}

