/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable$ASMData;
import cpw.mods.fml.common.discovery.ASMDataTable$ModContainerPredicate;
import cpw.mods.fml.common.discovery.ModCandidate;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ASMDataTable {
    private SetMultimap<String, ASMDataTable$ASMData> globalAnnotationData = HashMultimap.create();
    private Map<ModContainer, SetMultimap<String, ASMDataTable$ASMData>> containerAnnotationData;
    private List<ModContainer> containers = Lists.newArrayList();

    public SetMultimap<String, ASMDataTable$ASMData> getAnnotationsFor(ModContainer modContainer) {
        if (this.containerAnnotationData == null) {
            ImmutableMap.Builder<ModContainer, ImmutableSetMultimap<String, ASMDataTable$ASMData>> builder = ImmutableMap.builder();
            for (ModContainer modContainer2 : this.containers) {
                Multimap<String, ASMDataTable$ASMData> multimap = Multimaps.filterValues(this.globalAnnotationData, new ASMDataTable$ModContainerPredicate(modContainer2));
                builder.put(modContainer2, ImmutableSetMultimap.copyOf(multimap));
            }
            this.containerAnnotationData = builder.build();
        }
        return this.containerAnnotationData.get(modContainer);
    }

    public Set<ASMDataTable$ASMData> getAll(String string) {
        return this.globalAnnotationData.get(string);
    }

    public void addASMData(ModCandidate modCandidate, String string, String string2, String string3, Map<String, Object> map) {
        this.globalAnnotationData.put(string, new ASMDataTable$ASMData(modCandidate, string, string2, string3, map));
    }

    public void addContainer(ModContainer modContainer) {
        this.containers.add(modContainer);
    }
}

