/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import argo.jdom.JsonNode;
import argo.jdom.JsonNodeBuilders;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata$JsonStringConverter;
import cpw.mods.fml.common.functions.ModNameFunction;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModMetadata {
    public String modId;
    public String name;
    public String description = "";
    public String url = "";
    public String updateUrl = "";
    public String logoFile = "";
    public String version = "";
    public List<String> authorList = Lists.newArrayList();
    public String credits = "";
    public String parent = "";
    public String[] screenshots;
    public ModContainer parentMod;
    public List<ModContainer> childMods = Lists.newArrayList();
    public boolean useDependencyInformation;
    public Set<ArtifactVersion> requiredMods;
    public List<ArtifactVersion> dependencies;
    public List<ArtifactVersion> dependants;
    public boolean autogenerated;

    public ModMetadata(JsonNode object) {
        object = Maps.transformValues(((JsonNode)object).getFields(), new ModMetadata$JsonStringConverter());
        this.modId = (String)object.get(JsonNodeBuilders.aStringBuilder("modid"));
        if (Strings.isNullOrEmpty(this.modId)) {
            throw new LoaderException();
        }
        this.name = Strings.nullToEmpty((String)object.get(JsonNodeBuilders.aStringBuilder("name")));
        this.description = Strings.nullToEmpty((String)object.get(JsonNodeBuilders.aStringBuilder("description")));
        this.url = Strings.nullToEmpty((String)object.get(JsonNodeBuilders.aStringBuilder("url")));
        this.updateUrl = Strings.nullToEmpty((String)object.get(JsonNodeBuilders.aStringBuilder("updateUrl")));
        this.logoFile = Strings.nullToEmpty((String)object.get(JsonNodeBuilders.aStringBuilder("logoFile")));
        this.version = Strings.nullToEmpty((String)object.get(JsonNodeBuilders.aStringBuilder("version")));
        this.credits = Strings.nullToEmpty((String)object.get(JsonNodeBuilders.aStringBuilder("credits")));
        this.parent = Strings.nullToEmpty((String)object.get(JsonNodeBuilders.aStringBuilder("parent")));
        this.authorList = Objects.firstNonNull((List)object.get(JsonNodeBuilders.aStringBuilder("authors")), Objects.firstNonNull((List)object.get(JsonNodeBuilders.aStringBuilder("authorList")), this.authorList));
        this.requiredMods = this.processReferences(object.get(JsonNodeBuilders.aStringBuilder("requiredMods")), HashSet.class);
        this.dependencies = this.processReferences(object.get(JsonNodeBuilders.aStringBuilder("dependencies")), ArrayList.class);
        this.dependants = this.processReferences(object.get(JsonNodeBuilders.aStringBuilder("dependants")), ArrayList.class);
        this.useDependencyInformation = Boolean.parseBoolean(Strings.nullToEmpty((String)object.get(JsonNodeBuilders.aStringBuilder("useDependencyInformation"))));
    }

    public ModMetadata() {
    }

    private <T extends Collection<ArtifactVersion>> T processReferences(Object iterator, Class<? extends T> object2) {
        Collection collection = null;
        try {
            collection = (Collection)((Class)object2).newInstance();
        }
        catch (Exception exception) {}
        if (iterator == null) {
            return (T)collection;
        }
        for (Object object2 : (List)((Object)iterator)) {
            collection.add(VersionParser.parseVersionReference((String)object2));
        }
        return (T)collection;
    }

    public String getChildModCountString() {
        return String.format("%d child mod%s", this.childMods.size(), this.childMods.size() != 1 ? "s" : "");
    }

    public String getAuthorList() {
        return Joiner.on(", ").join(this.authorList);
    }

    public String getChildModList() {
        return Joiner.on(", ").join(Lists.transform(this.childMods, new ModNameFunction()));
    }

    public String printableSortingRules() {
        return "";
    }
}

